	  page 0
	  cpu 8051
	  include "stddef51.inc"

; **********************************************************************
;  Sun Remarketing MFM Controller Board
;  Firmware Rev. D
;  (c) ??? SUN REMARKETING
;
; commented disassembly 2000, 2005-2006 by Dr. P. Schfer
; dr.p.schaefer@web.de
; **********************************************************************


; *** Hardware addresses
;
MFM_HdSel2	EQU P1.0	; (to P5 pin 4) MFM head select lines
MFM_HdSel1	EQU P1.1	; (to P5 pin 18)
MFM_HdSel0	EQU P1.2	; (to P5 pin 14)
MFM_DirIn 	EQU P1.3	; (to P5 pin 34) set for stepper direction inwards
PBusy		EQU P1.4
MFM_Step	EQU P1.5	; (to P5 pin 24) stepper pulse
MFM_DriveSel	EQU P1.6	; (to P5 pin 26, 28) 1=Drive 1, 0=Drive 2
MFM_EnPrec	EQU P1.7	; (to Omti 20507 pin 11) enable precompensation
SeqInt		EQU P3.2	; INT0 (from Omti sequencer)
PCmd		EQU P3.3	; INT1
MFM_SeekCmplt	EQU P3.4	; T0 (from P5 pin 8) set when seek completed
MFM_RdyFault	EQU P3.5	; T1 (from P5 pin 12+22) set when drive ready and no write fault occured
;
; 0000 .. 001F	Omti Memory Controller
; This is taken from the Omti PFM 5060 manual, which is NOT our controller !!!
;
Omti_base 	EQU 0000h
OmtiMC_Ch0AdrL	EQU 00000b	; 00h DMA channel 0 (W)
OmtiMC_Ch0AdrH	EQU 00001b
OmtiMC_Ch0CntL	EQU 00010b
OmtiMC_Ch0CntH	EQU 00011b
OmtiMC_Ch1AdrL	EQU 00100b	; 04h DMA channel 1 (W)
OmtiMC_Ch1AdrH	EQU 00101b
OmtiMC_Ch1CntL	EQU 00110b
OmtiMC_Ch1CntH	EQU 00111b
OmtiMC_Ch2AdrL	EQU 01000b	; 08h DMA channel 2 (W)
OmtiMC_Ch2AdrH	EQU 01001b
OmtiMC_Ch2CntL	EQU 01010b
OmtiMC_Ch2CntH	EQU 01011b
OmtiMC_Ch3AdrL	EQU 01100b	; 0Ch DMA channel 3 (W)
OmtiMC_Ch3AdrH	EQU 01101b
OmtiMC_Ch3CntL	EQU 01110b
OmtiMC_Ch3CntH	EQU 01111b
OmtiMC_Ch0Ctrl	EQU 10000b	; 10h DMA channel control (W)
OmtiMC_Ch1Ctrl	EQU 10001b
OmtiMC_Ch2Ctrl	EQU 10010b
OmtiMC_Ch3Ctrl	EQU 10011b
OmtiMC_MemTim	EQU 10100b
OmtiMC_ExtStb0	EQU 11000b	; 18h External Strobes (R/W)
OmtiMC_ExtStb1	EQU 11001b	; 19h
OmtiMC_ExtStbA	EQU 11100b	; 1C..1Fh
OmtiMC_Status	EQU 00000b	; 00h Status (R)
;
; 0020 .. 003F	Omti Sequencer
; This is taken from the Omti PFM 5050 manual, which is NOT our controller !!!
;
OmtiDS_Command	EQU 100000b	; 20h command (W)
OmtiDS_Status	EQU 100000b	; 20h status (R)
OmtiDS_SeqLCnt	EQU 100001b	; 21h number of sectors resp. sequencer loops (W)
OmtiDS_ExtStat	EQU 100001b	; 21h extended status (R)
OmtiDS_TimeOut	EQU 100010b	; 22h index time-out (0..15 disk revolutions) (W)
OmtiDS_StatAdr	EQU 100010b	; 22h state address + retry count (R)
OmtiDS_SctrSBC	EQU 100011b	; 23h sub-blocks per sector (W)
OmtiDS_Flag	EQU 100011b	; 23h flag byte (Header Byte 4) (R)
OmtiDS_CylH	EQU 100100b	; 24h Cylinder High (Header Byte 0) (R/W)
OmtiDS_CylL	EQU 100101b	; 25h Cylinder Low (Header Byte 1) (R/W)
OmtiDS_Head	EQU 100110b	; 25h Head / Flag (Header Byte 2) (R/W)
OmtiDS_Sector	EQU 100111b	; 27h Sector (Header Byte 3) (R/W)
OmtiDS_MCtoMem	EQU 101000b	; 28h micro to memory (W)
OmtiDS_MemToMC	EQU 101000b	; 28h memory to micro (R)
OmtiDS_SeqStart	EQU 101001b	; 29h sequencer restart + start state (W)
OmtiDS_SeqState	EQU 101001b	; 29h sequencer loop count (R)
OmtiDS_SeqStop	EQU 101010b	; 2Ah sequencer loop end state
OmtiDS_BRStart	EQU 101011b	; 2Bh bit ring start (W)
OmtiDS_ECCctrl	EQU 101100b	; 2Ch ECC control (W)
OmtiDS_EncCtrl	EQU 101101b	; 2Dh encode / decode control (W)
OmtiDS_SeqCnt	EQU 101110b	; 2Eh sequencer counter register (R/W)
OmtiDS_SeqVal	EQU 101111b	; 2Fh sequencer value register (R/W)
OmtiDS_ECC0	EQU 110000b	; 30h ECC polynominal 0..7 (W)
OmtiDS_ECC1	EQU 110001b	; 31h ECC polynominal 8..15 (W)
OmtiDS_ECC2	EQU 110010b	; 32h ECC polynominal 16..23 (W)
OmtiDS_ECC3	EQU 110011b	; 33h ECC polynominal 24..31 (W)
OmtiDS_ECC4	EQU 110100b	; 34h ECC polynominal 32..39 (W)
OmtiDS_ECC5	EQU 110101b	; 35h ECC polynominal 40..47 (W)
OmtiDS_ECC6	EQU 110110b	; 36h ECC polynominal 48..55 (W)
OmtiDS_ECC7	EQU 110111b	; 37h ECC polynominal 56..63 (W)
OmtiDS_ExtStb0	EQU 111000b	; 38h External Strobes (R/W)
OmtiDS_ExtStb1	EQU 111001b	; 39h
OmtiDS_ExtStbA	EQU 111100b	; 3C..3Fh
OmtiDS_MemToGrp	EQU 111011b	; 3Bh micro-DMA memory to group
;
; 00E0 .. 00EF	Omti SCSI controller
; at least we know that this is NOT compatible to the 5k chipset...
;
; 8000 .. 9FFF	RAM
XRAMstart	EQU 08000h



; *** internal RAM addresses
;
	segment data
	Using Bank0		; R0..R7
Stack		EQU 008h	; 24 bytes
;
; 020h	-> 000..007h
; 021h	-> 008..00Fh
; 022h	-> 010..017h
Target_CylH	EQU 023h	; 023h	-> 018..01Fh
Target_CylL	EQU 024h	; 024h	-> 020..027h
; 025h	-> 028..02Fh
LimitFlag	EQU 02Eh
; 026h	-> 030..037h
; 027h	-> 038..03Fh
; 028h	-> 040..047h
; 	EQU 040h
; 	EQU 041h
IntegerFlag	EQU 047h	; set for integer, cleared for byte value
; 029h	-> 048..04Fh
; 	EQU 04Ch
Interleave	EQU 02Ah	; 02Ah	-> 050..057h
; 02Bh	-> 058..05Fh
; 02Ch	-> 060..067h
; 02Dh	-> 068..06Fh
; 02Eh	-> 070..077h
; 	EQU 070h
RecalTo_Trk1	EQU 077h
; 02Fh	-> 078..07Fh
ConfigJumper 	EQU 078h
; 	EQU 079h
ErrorFlag	EQU 07Eh
;
;		EQU 030h
;		EQU 031h
;		EQU 032h
;		EQU 033h
;		EQU 034h
;		EQU 035h
; BufPtr	EQU 036h	; position in command buffer (R0)
;		EQU 037h
VolumeSizeH	EQU 038h	; Profile volume size
VolumeSizeM	EQU 039h
VolumeSizeL	EQU 03Ah
;		EQU 03Bh
;		EQU 03Ch
;		EQU 03Dh
tmp_Cyl4	EQU 03Eh
tmp_Cyl3	EQU 03Fh
tmp_Cyl2	EQU 040h
tmp_Cyl1	EQU 041h
tmp_Hd		EQU 042h
;		EQU 043h
DefectList_Ptr	EQU 044h	; LSB pointer into defect list
;		EQU 045h
;		EQU 046h
;		EQU 047h
;		EQU 048h
;		EQU 049h
;		EQU 04Ah
;		EQU 04Bh
;		EQU 04Ch
;		EQU 04Dh
;		EQU 04Eh
;		EQU 04Fh
;		EQU 050h
;		EQU 051h
;		EQU 052h
StepsToGoH	EQU 053h	; for seek routine
StepsToGoL	EQU 054h
;		EQU 055h
;		EQU 056h
LBA_Hi		EQU 057h
LBA_Mi		EQU 058h
LBA_Lo		EQU 059h
;		EQU 05Ah
; 		EQU 05Bh
; 		EQU 05Ch
; 		EQU 05Dh
; 		EQU 05Eh
; 		EQU 05Fh
; 		EQU 060h
LBA_Hi1		EQU 061h
LBA_Mi1		EQU 062h
LBA_Lo1		EQU 063h
GeometryStart	EQU 068h	; they like to reference it indexed, perhaps for future two drive mode ?
Current_CylH	EQU 068h	; current position
Current_CylL	EQU 069h
Current_Hd	EQU 06Ah
Current_Sec	EQU 06Bh
NumberOf_CylH	EQU 06Ch	; number of cylinders -2
NumberOf_CylL	EQU 06Dh
NumberOf_Hd	EQU 06Eh	; number of heads -1
NumberOf_Sec	EQU 06Fh	; number of sectors -1
NumberOf_PCyH	EQU 070h	; precompensation start cylinder -1
NumberOf_PCyL	EQU 071h
LUNstatusByte	EQU 072h	; LUN status byte
FlagByte	EQU 073h	; Flag byte
;		EQU 074h	; 00
;		EQU 075h	; bit 7 set when track position unknown
;		EQU 076h	; 00
;		EQU 077h	; 00
;		EQU 078h	; 00
;		EQU 079h	; 00
;		EQU 07Ah	; 00
;		EQU 07Bh
;		EQU 07Ch	; 00
;		EQU 07Dh	; 00
;		EQU 07Eh	; 00
; 		EQU 07Fh



; *** ROM entry vectors
;
	segment code
	ORG 000h
RESET		LJMP MainStart
	ORG 003h
EXTI0		LJMP Int_EXT0
	ORG 00Bh
TIMER0		LJMP Int_T0
	ORG 013h
EXTI1		LJMP Int_EXT1
	ORG 01Bh
TIMER1		LJMP Int_T1
	ORG 023h
SINT		RETI


; **********************************************************************
;  Cold start after Reset
;  Set up MFM chipset, ..., ?
; **********************************************************************
;
	ORG 029h
MainStart	MOV SP, #Stack
		MOV P2, #Omti_base
		MOV 26h, #0h
		MOV 2Fh, #0h
		CLR 40h
		CLR LimitFlag
		CLR 79h
		CLR ConfigJumper
		CLR 70h
		CLR MFM_Step
		CLR MFM_HdSel0
		CLR MFM_HdSel1
		CLR MFM_HdSel2
		CLR MFM_EnPrec
		CLR 41h
		CLR 4Ch
		SETB MFM_DirIn
		SETB MFM_DriveSel	; select drive 1
		MOV 4Fh, #0h
		MOV 4Eh, #0h
		MOV 2Fh, #0h
		SETB EA
		MOV R2, #0FEh
		MOV R3, #8h
		LCALL Delay		; delay for 08FEh
		MOV DPTR, #0E2h
_0066:		MOVX A, @DPTR		; read Omti SCSI status port??
		JB Acc.4, _0066		; wait for something to get ready
		LCALL Ser_Init		; set up RS232 (2k4 no parity)
		MOV A, #0Fh
		MOVX @DPTR, A
		MOV DPTR, #0E0h
		MOVX A, @DPTR		; read 00E0
		INC DPTR
		MOVX A, @DPTR		; read 00E1
		INC DPTR
		MOVX A, @DPTR		; read 00E2
		MOV R0, #0E4h
		MOVX A, @R0		; read 00E4
		PUSH Acc
		JNB Acc.4, _0082
		SETB ConfigJumper
_0082:		JB Acc.3, _0092
		MOV R0, #0E2h
		MOV A, #6h
		MOVX @R0, A		; 006h into 00E2h
		MOV R0, #0E1h
		MOV A, #83h
		MOVX @R0, A		; 083h into 00E1h
		LJMP _009E
_0092:		SETB 79h
		MOV R0, #0E1h
		MOV A, #3h
		MOVX @R0, A		; 003h into 00E1h
		MOV R0, #0E2h
		MOV A, #6h
		MOVX @R0, A		; 006h into 00E2h
_009E:		SETB 79h
		MOV A, #7
		MOVX @R0, A
		MOV R0, #0E5h
		MOV R6, #1h
		POP Acc			; get back value from 00E4h
		ANL A, #7		; mask out SCSI ID
		JZ _00B3
		MOV R7, A
_00AE:		MOV A, R6
		RL A
		MOV R6, A
		DJNZ R7, _00AE
_00B3:		MOV A, R6		; calculate 2^ID
		MOVX @R0, A		; into 00E5h SCSI ID register
		MOV B, #2h
		MOV DPTR, #_1B6A
		MOV A, #2h
		MOVC A, @A+DPTR
		MOV R4, A		; (1B6Ch) into R4
		ORL A, #80h
		MOV R5, A		; (1B6Ch) OR 080h into R5
		MOV R0, #GeometryStart
		MOV DPTR, #RAMinit_Table
		MOV R7, #14
		DEC R7
		MOV R1, #0
RAMinit		MOV A, R1
		MOVC A, @A+DPTR		; initialize geometry data at RAM locations 068h..075h
		MOV @R0, A		; with values from 1B5C..1B69
		INC R1
		INC R0
		DJNZ R7, RAMinit
;
		MOV A, R0
		MOV R1, A		; 076h into R1
		CLR C
		SUBB A, #6h
		MOV R0, A		; NumberOf_PCyH into R0
		MOV A, R4
		MOV @R0, A		; R4 into NumberOf_PCyH
		MOV A, B
		MOV @R1, A		; 2 into 076h
; set up Omti Memory controller
		MOV R0, #OmtiMC_Ch0AdrL
		MOV R7, #16
		CLR A
OmtiInit_1	MOVX @R0, A		; clear first 16 Omti registers
		INC R0 			;  (DMA channels)
		DJNZ R7, OmtiInit_1
;
		MOV R7, #5
		MOV B, #0h
		MOV R0, #OmtiMC_Ch0Ctrl
OmtiInit_2	MOV DPTR, #OmtiInit_Table1
		MOV A, B
		MOVC A, @A+DPTR		; initialize Omti Registers 10..15h
		MOVX @R0, A		;  with values from 1B1F..1B23
		MOV A, B
		INC A
		MOV B, A
		INC R0
		DJNZ R7, OmtiInit_2
; Set up Omti Sequencer
		LCALL OmtiInit_3
		JNB F0, OmtiInit_4	; set when error
		SETB ErrorFlag
OmtiInit_4	LCALL _17D0
		JNB F0, _010D
		SETB 7Dh
_010D		LCALL _19C4
		JNB F0, _0115
		SETB 7Fh
_0115		SETB RecalTo_Trk1
		LCALL GoTo_Trk0_1
		JB F0, _0149
		MOV 76h, #0h
		LCALL _16E2
		MOV A, #0Dh
		ADD A, #GeometryStart
		MOV R0, A
		MOV A, #82h
		MOV @R0, A		; 082h in 075h
		LCALL _0C2D
		SETB 40h
		CLR 2Dh
		MOV 56h, #8h
		MOV LBA_Hi, #0h
		MOV LBA_Mi, #0h
		MOV LBA_Lo, #0h
		MOV 5Ah, #3h
		MOV 5Bh, #0h
		SETB 6Fh
		LCALL _0EED
_0149		JB F0, _01AB
; read first sector from disk
		MOV R2, #0h
		MOV R3, #0h
		LCALL Omti_DMAdrSet	; set DMA address to 0000h
		MOV R6, #0h
		MOV R7, #6h		; transfer 0600h bytes
		MOV DPTR, #XRAMstart
		LCALL MFM_ReadSctr
		MOV DPTR, #XRAMstart
		MOVX A, @DPTR		; get first byte from buffer
		CJNE A, #0AAh, _01AB	; not AAh ->
		INC DPTR
		MOVX A, @DPTR		; get second byte from buffer
		CJNE A, #0AAh, _01AB	; not AAh ->
		INC DPTR
		MOV R6, #0h
		MOV R0, #GeometryStart
		MOV R7, #14
; copy 14 bytes from RAM buffer into 68..74h
_0170		MOVX A, @DPTR		; get parameter byte from buffer
		MOV @R0, A		;  and store it into RAM
		INC DPTR
		INC R0
		INC R6
		MOV A, R6
		CJNE A, #0Ah, _017F	; next one
		CLR A
		MOV @R0, A		; skip & clear LUNstatusByte
		INC R0
		MOV @R0, A		; (useless, will be overwritten next loop!)
		DEC R7
		DEC R7
_017F:		DJNZ R7, _0170
;
		MOV DPTR, #8226h
		MOVX A, @DPTR
		INC DPTR
		CPL A
		MOV VolumeSizeH, A	; VolumeSizeH = / (byte 226h)
		MOVX A, @DPTR
		INC DPTR
		CPL A
		MOV VolumeSizeM, A	; VolumeSizeM = / (byte 227h)
		MOVX A, @DPTR
		CPL A
		MOV VolumeSizeL, A	; VolumeSizeL = / (byte 228h)
		CLR RecalTo_Trk1
		LCALL GoTo_Trk0_1
		JB F0, _01AB
		MOV R0, #0E4h
		MOVX A, @R0		; get 00E4
		JB Acc.3, _01AF
		CLR 79h
_01A2:		JNB 79h, _01A8
		LJMP _01BB
_01A8:		LJMP _0205
;
_01AB:		SETB ConfigJumper
		SJMP _01A2
_01AF:		SETB 79h
		SJMP _01A2
_01B3:		MOV SP, #8h
		MOV R0, #0E2h
		MOV A, #4h
		MOVX @R0, A		; 04 into 00E2
_01BB:		MOV R0, #0E1h
		MOV A, #3h
		MOVX @R0, A		; 03, 06, 04, 05 into 00E1
		MOV A, #6h
		MOVX @R0, A
		MOV A, #4h
		MOVX @R0, A
		MOV A, #5h
		MOVX @R0, A
		CLR A
		MOV 76h, A
		MOV 78h, A
		MOV 77h, A
		MOV 65h, A
		MOV 2Dh, A
		MOV DPTR, #0E2h
		MOVX A, @DPTR		; get 00E2
		MOV P2, #Omti_base
		MOV R0, #OmtiMC_Ch2Ctrl
		MOV A, #8Eh
		MOVX @R0, A		; set up DMA channel 2
		LCALL _0C2D
		JB ConfigJumper, GoInteractive1
		SETB 30h
		SETB 37h
		LCALL _0BE5
_01ED:		JB ConfigJumper, GoInteractive1
		LJMP _01ED
GoInteractive1	LJMP GoInteractive


_01F6:		LCALL _0304		; *** dead code? ***
		LJMP _01FC


_01FC		MOV SP, #Stack
		LCALL _0A97
		LJMP _01B3

_0205		LCALL _0C2D
		JB ConfigJumper, GoInteractive1
		MOV R1, #0E2h
		MOV A, #2h
		MOVX @R1, A		; 2 into 00E2
		MOV R7, #4h
		MOV R1, #60h
_0214:		MOV A, #0FFh
		MOV @R1, A		; FF into 60..63
		INC R1
		DJNZ R7, _0214
		LCALL _0CDB
		CLR A
		MOV 76h, A
		MOV 78h, A
		MOV 77h, A
		MOV 65h, A
		MOV 2Dh, A
		SETB 6Fh
		MOV DPTR, #0E2h
		MOVX A, @DPTR		; read 00E2
		MOV R0, #0E2h
		MOV A, #81h
		MOVX @R0, A		; 81 into 00E2
		MOV SP, #8h
		MOV R0, #0E2h
		MOV A, #84h
		MOVX @R0, A		; 84 into 00E2
_023B 		MOV SP, #8h
		MOV R1, #0E6h
		MOV A, #0h
		MOVX @R1, A		; 0 into 00E6
		SETB 37h
		LCALL _0BE5
		MOV R0, #0E1h
		MOV A, #3h
		MOVX @R0, A		; 3 into 00E1
		MOV R1, #0E2h
		MOV A, #81h
		MOVX @R1, A		; 81 into 00E2
		MOV A, #84h
		MOVX @R1, A		; 84 into 00E2
_0255:		MOVX A, @R0
		JNB Acc.7, _0255	; wait for 00E1.7 to go high
_0259:		MOV SP, #8h
		MOV R1, #0E2h
		MOV A, #2h
		MOVX @R1, A		; 2 into 00E2
		MOV R1, #0E6h
		MOV A, #0FEh
		MOVX @R1, A		; FE into 00E6
		MOV A, #83h
		MOVX @R0, A		; 83 into 00E1
_0269:		MOVX A, @R0
		JB Acc.7, _0269		; wait for 00E1.7 to go low
		MOV R1, #0E5h
		MOVX A, @R1		; get 00E5
		CJNE A, #0AAh, _02A6	; everything seems to be inverted so this may be 55h
		MOV R1, #OmtiMC_Ch2Ctrl	; configure DMA Ch 2 for write
		MOV A, #13h
		MOVX @R1, A
		MOV R2, #0h
		MOV R3, #0h
		LCALL Omti_DMAdrSet	; set DMA address to 0000
		MOV R0, #OmtiMC_Ch3Ctrl
		MOV A, #31h
		MOVX @R0, A		; configure DMA Ch 3 for read
		MOV 3Dh, #0h
		SETB 35h
		LCALL _0BE5
		MOV R1, #0E2h
		MOV R0, #0E1h
		MOV A, #3h
		MOVX @R0, A		; 3 into 00E1
		MOV A, #82h
_0295:		MOVX @R1, A		; 82 into 00E1
		SJMP _0295		; forever or until INT occurs


_0298:		MOV R1, #56h		; *** dead code? ***
		MOV R0, #28h
		MOVX A, @R0
		MOVX A, @R0
		CPL A
		MOV @R1, A
		LCALL _02BD
		LJMP _0259


_02A6:		MOV R1, #60h
		MOV A, #7Fh
		MOV @R1, A		; 7F into 60h
		INC R1
		MOV R7, #3h
		MOV A, #0FFh
_02B0:		MOV @R1, A		; FF into 61..67h
		INC R1
		DJNZ R7, _02B0
		LCALL _0CDB
		LCALL _0449
		LJMP _0259


_02BD:		CJNE A, #1h, _02C4	; *** dead code? ***
		MOV A, #0FCh
		SJMP _02CD
_02C4:		CJNE A, #2h, _02CB
		MOV A, #0FBh
		SJMP _02CD
_02CB:		MOV A, #0FDh
_02CD:		PUSH ACC
		MOV R1, #0E2h
		MOV A, #2h
		MOVX @R1, A		; 02 into 00E2
		POP ACC
		MOV R1, #0E6h
		MOVX @R1, A		; FB, FC or FD into 00E6
		MOV R0, #0E1h
		MOV A, #83h
		MOVX @R0, A		; 83 into 00E1
		MOV R1, #LBA_Hi-1
		INC R1
_02E1:		MOVX A, @R0
		JB ACC.7, _02E1		; wait for 00E1.7 to go low
		MOV R0, #OmtiDS_MCtoMem
		MOVX A, @R0		; get byte from DMA
		CPL A
		MOV @R1, A		; complement into LBA_Hi
		INC R1
		MOVX A, @R0		; get next byte from DMA
		CPL A
		MOV @R1, A		; complement into LBA_Mi
		INC R1
		MOVX A, @R0		; get next byte from DMA
		CPL A
		MOV @R1, A		; complement into LBA_Lo
		MOV R1, #0E5h
		MOVX A, @R1		; read 00E5
		CJNE A, #0AAh, _02A6	; everything seems to be inverted so this may be 55h
		MOV DPTR, #1BADh
		MOV R1, #56h
		MOV A, @R1
		CLR C
		MOV B, #3h
		MUL AB
		JMP @A+DPTR		; jump depending on (56)


_0304:	LCALL	_0C2D			;0304  12 0C 2D  dead?
	MOV	A, 56h			;0307  E5 56
	XRL	A, #3h			;0309  64 03
	JNZ	_030F			;030B  70 02
	SJMP	_0318			;030D  80 09
_030F:	MOV	64h, #0h		;030F  75 64 00
	MOV	74h, #0h		;0312  75 74 00
	LCALL	LBAtoLBA1
_0318:	MOV	DPTR, #_1BB6		;0318  90 1B B6
	MOV	R7, #0h			;031B  7F 00
	MOV	R6, #20h		;031D  7E 20
_031F:	CLR	A			;031F  E4
	MOVC	A, @A+DPTR		;0320  93
	CJNE	A, 56h, _0326		;0321  B5 56 02
	SJMP	_0336			;0324  80 10
_0326:	INC	DPTR			;0326  A3
	INC	R7			;0327  0F
	DJNZ	R6, _031F		;0328  DE F5
	LCALL	_0B7C			;032A  12 0B 7C
	MOV	64h, #20h		;032D  75 64 20
	MOV	74h, #5h		;0330  75 74 05
	LJMP	_01FC			;0333  02 01 FC
_0336:	MOV	A, R6			;0336  EE
	CJNE	A, #19h, _033C		;0337  B4 19 02
	SJMP	_0353			;033A  80 17
_033C:	JC	_0353			;033C  40 15
	JNB	7Bh, _0353		;033E  30 7B 12
	MOV	64h, #4Dh		;0341  75 64 4D
	MOV	74h, #4h		;0344  75 74 04
	LJMP	_01FC			;0347  02 01 FC
_034A:	MOV	64h, #25h		;034A  75 64 25
	MOV	74h, #5h		;034D  75 74 05
	LJMP	_01FC			;0350  02 01 FC
_0353:	MOV	A, LBA_Hi
	ANL	A, #0E0h		;0355  54 E0
	JNZ	_034A			;0357  70 F1
	LCALL	_16E2			;0359  12 16 E2
	MOV	4Ch, 5Ah		;035C  85 5A 4C
	MOV	DPTR, #_1BD6		;035F  90 1B D6
	MOV	A, R7			;0362  EF
	CLR	C			;0363  C3
	MOV	B, #3h			;0364  75 F0 03
	MUL	AB			;0367  A4
	JMP	@A+DPTR			;0368  73

_0369:		JB 40h, _0372
_036C:		MOV 64h, #4h
		LJMP _16F2
_0372:		RET
_0373:		LCALL _0369
		JNB 40h, _036C


; ***
; *** recalibrate MFM drive to track 0 or 1
; ***
;
Do_Rezero	LCALL SelectDrive1
		MOV A, 5Bh
		JB Acc.7, Do_Rezero1
		LCALL GoTo_Trk0_1
		CLR A
Do_Rezero2	MOV DPTR, #XRAMstart	; current track?
		MOVX @DPTR, A
		MOV 4Eh, #0h
		MOV 4Fh, #0h
		MOV LBA_Hi, #0h
		MOV LBA_Mi, #0h
		MOV LBA_Lo, #0h
		RET
;
Do_Rezero1	SETB RecalTo_Trk1
		LCALL GoTo_Trk0_1
		CLR RecalTo_Trk1
		MOV A, #1h
		SJMP Do_Rezero2



_03A4		LJMP _0ADE

Do_Format	MOV 78h, #6h
		ACALL _0373
		LCALL _1D08
		LCALL _09E9
		LCALL _1156
		LCALL SelectDrive1
_03B8		LCALL _0848
		LCALL _12B6
		JNB F0, _03B8
		MOV A, 64h
		CJNE A, #23h, _03C9
		MOV 64h, #0h
_03C9		LJMP _03DE

_03CC		MOV 49h, #2h
		LJMP RESET

_03D2		MOV 78h, #6h
		LCALL _0373
		LCALL SelectDrive1
		LCALL _0842
_03DE		LJMP OmtiInit_32		; initialize OMTI sequencer and return

_03E1		MOV 76h, #80h
		LJMP _03D2

; read system track
_03E7		LCALL SelectDrive1
		LCALL _0EED
		JB F0, _0402
		JB 6Fh, _0401
		SETB EX1
		LJMP _11F1
; write system track
_03F8		LCALL SelectDrive1
		LCALL _0EF8
		JB F0, _0402
_0401		RET
_0402		LJMP _16F2


_0405		LCALL	_0C2D
	LCALL	_16E2			;0408  12 16 E2
	MOV	5Ah, #1h		;040B  75 5A 01
	MOV	5Bh, #0h		;040E  75 5B 00
	MOV	A, LBA_Hi			;0411  E5 57
	CJNE	A, #0FFh, _042E		;0413  B4 FF 18
	MOV	A, LBA_Mi			;0416  E5 58
	CJNE	A, #0FFh, _042E		;0418  B4 FF 13
	MOV	A, LBA_Lo			;041B  E5 59
	CJNE	A, #0FFh, _042E		;041D  B4 FF 0E
	SETB	RecalTo_Trk1			;0420  D2 77
	LCALL	GoTo_Trk0_1			;0422  12 1C A2
	MOV	LBA_Hi, #0h		;0425  75 57 00
	MOV	LBA_Mi, #0h		;0428  75 58 00
	MOV	LBA_Lo, #1h		;042B  75 59 01
_042E:	LCALL	_0EED			;042E  12 0E ED
	JB	F0, _0402		;0431  20 D5 CE
	JBC	RecalTo_Trk1, _0439
	SJMP	_043C			;0437  80 03
_0439:	LCALL	GoTo_Trk0_1
_043C:	MOV	R7, #4h			;043C  7F 04
	MOV	R1, #60h		;043E  79 60
_0440:	MOV	A, #0FFh		;0440  74 FF
	MOV	@R1, A			;0442  F7
	INC	R1			;0443  09
	DJNZ	R7, _0440		;0444  DF FA
	LCALL	_0CDB			;0446  12 0C DB

_0449:	MOV	R2, #6h			;0449  7A 06
	MOV	R3, #0h			;044B  7B 00
	LCALL	Omti_DMAdr23Set
	MOV	R1, #56h		;0450  79 56
	MOV	A, #82h			;0452  74 82
	MOVX	@R0, A			;0454  F2
	MOV	R1, #12h		;0455  79 12
	MOV	A, #91h			;0457  74 91
	MOVX	@R1, A			;0459  F3
	MOV	A, #71h			;045A  74 71
	MOVX	@R1, A			;045C  F3
	MOV	3Dh, #1h		;045D  75 3D 01
	MOV	DPTR, #1Ch		;0460  90 00 1C
	MOVX	@DPTR, A		;0463  F0
	SETB	35h			;0464  D2 35
	LCALL	_0BE5			;0466  12 0B E5
	MOV	R1, #0E2h		;0469  79 E2
	MOV	A, #2h			;046B  74 02
	MOVX	@R1, A			;046D  F3
	MOV	R1, #0E6h		;046E  79 E6
	MOV	A, #0FFh		;0470  74 FF
	MOVX	@R1, A			;0472  F3
	MOV	R1, #0E2h		;0473  79 E2
	MOV	R0, #0E1h		;0475  78 E1
	MOV	A, #3h			;0477  74 03
	MOVX	@R0, A			;0479  F2
	MOV	A, #82h			;047A  74 82
_047C:	MOVX	@R1, A			;047C  F3
	SJMP	_047C			;047D  80 FD
	RET

_0480		MOV R1, #12h
	MOV	A, #13h			;0482  74 13
	MOVX	@R1, A			;0484  F3
	MOV	R2, #0Ah		;0485  7A 0A
	MOV	R3, #0h			;0487  7B 00
	LCALL	Omti_DMAdr23Set
	MOV	3Dh, #2h		;048C  75 3D 02
	SETB	35h			;048F  D2 35
	LCALL	_0BE5			;0491  12 0B E5
	MOV	R1, #0E2h		;0494  79 E2
	MOV	R0, #0E1h		;0496  78 E1
	MOV	A, #82h			;0498  74 82
	MOVX	@R1, A			;049A  F3
	SETB	MFM_EnPrec
	NOP				;049D  00
	NOP				;049E  00
	CLR	MFM_EnPrec
	NOP				;04A1  00
	NOP				;04A2  00
	SETB	MFM_EnPrec
	MOV	A, #3h			;04A5  74 03
	MOVX	@R0, A			;04A7  F2
	MOV	A, #82h			;04A8  74 82
_04AA:	MOVX	@R1, A			;04AA  F3
	SJMP	_04AA			;04AB  80 FD

_04AD:	MOV	R1, #0E2h		;04AD  79 E2   dead?
	MOV	A, #2h			;04AF  74 02
	MOVX	@R1, A			;04B1  F3
	MOV	R0, #0E6h		;04B2  78 E6
	MOV	A, #0F9h		;04B4  74 F9
	MOVX	@R0, A			;04B6  F2
	MOV	R0, #0E1h		;04B7  78 E1
	MOV	A, #83h			;04B9  74 83
	MOVX	@R0, A			;04BB  F2
_04BC:	MOVX	A, @R0			;04BC  E2
	JB	ACC.7, _04BC		;04BD  20 E7 FC
	MOV	R1, #0E5h		;04C0  79 E5
	MOVX	A, @R1			;04C2  E3
	CJNE	A, #0AAh, _04E3		;04C3  B4 AA 1D
	LCALL	_0C2D			;04C6  12 0C 2D
	LCALL	_16E2			;04C9  12 16 E2
	MOV	5Ah, #1h		;04CC  75 5A 01
	MOV	5Bh, #0h		;04CF  75 5B 00
	LCALL	_0EF8			;04D2  12 0E F8
	JB	F0, _04E6		;04D5  20 D5 0E
	JBC	RecalTo_Trk1, _04DD		;04D8  10 77 02
	SJMP	_04E0			;04DB  80 03
_04DD:	LCALL	GoTo_Trk0_1
_04E0:	LJMP	_043C			;04E0  02 04 3C
_04E3:	LJMP	_023B			;04E3  02 02 3B
_04E6:	LJMP	_0402			;04E6  02 04 02

_04E9		LJMP _1D08


; reassign bad block
_04EC		JB 6Fh, _0527
	MOV	R0, #0E2h		;04EF  78 E2
	MOV	A, #2h			;04F1  74 02
	MOVX	@R0, A			;04F3  F2
	MOV	R1, #5Ch		;04F4  79 5C
	MOV	R7, #3h			;04F6  7F 03
	CLR	72h			;04F8  C2 72
	SETB	34h			;04FA  D2 34
	LCALL	_0BE5			;04FC  12 0B E5
	MOV	R0, #0E7h		;04FF  78 E7
	MOVX	A, @R0			;0501  E2
_0502:	JBC	76h, _0507		;0502  10 76 02
	SJMP	_0502			;0505  80 FB
_0507:	MOVX	A, @R0			;0507  E2
	MOV	@R1, A			;0508  F7
	INC	R1			;0509  09
	SETB	34h			;050A  D2 34
	LCALL	_0BE5			;050C  12 0B E5
	DJNZ	R7, _0502		;050F  DF F1
	MOV	R0, #0E6h		;0511  78 E6
_0513:	JBC	76h, _051B		;0513  10 76 05
	SJMP	_0513			;0516  80 FB
_0518:	LJMP	_0402			;0518  02 04 02
_051B:	MOVX	A, @R0			;051B  E2
	MOV	@R1, A			;051C  F7
	MOV	R0, #0E1h		;051D  78 E1
	MOV	A, #5h			;051F  74 05
	MOVX	@R0, A			;0521  F2
	MOV	R0, #0E2h		;0522  78 E2
	MOV	A, #82h			;0524  74 82
	MOVX	@R0, A			;0526  F2
_0527:	MOV	A, LBA_Hi			;0527  E5 57
	ANL	A, #60h			;0529  54 60
	PUSH	Acc			;052B  C0 E0
	MOV	A, 5Ch			;052D  E5 5C
	ANL	A, #9Fh			;052F  54 9F
	MOV	5Ch, A			;0531  F5 5C
	POP	Acc			;0533  D0 E0
	ORL	A, 5Ch			;0535  45 5C
	MOV	5Ch, A			;0537  F5 5C
	CLR	4Ch			;0539  C2 4C
	LCALL	_1DB3			;053B  12 1D B3
	JB	F0, _0518		;053E  20 D5 D7
	MOV	A, #2h			;0541  74 02
	ADD	A, #GeometryStart
	MOV	R1, A			;0545  F9
	MOV	A, @R1			;0546  E7
	PUSH	Acc			;0547  C0 E0
	PUSH	4Eh			;0549  C0 4E
	PUSH	4Fh			;054B  C0 4F
	LCALL	_0CB4			;054D  12 0C B4
	LCALL	_1DB3			;0550  12 1D B3
	JB	F0, _0518		;0553  20 D5 C2
	MOV	A, #2h			;0556  74 02
	ADD	A, #GeometryStart
	POP	4h			;055A  D0 04
	POP	5h			;055C  D0 05
	POP	6h			;055E  D0 06
	MOV	R1, A			;0560  F9
	MOV	A, @R1			;0561  E7
	CJNE	A, 6h, _0575		;0562  B5 06 10
	MOV	A, 4Eh			;0565  E5 4E
	CJNE	A, 5h, _0575		;0567  B5 05 0B
	MOV	A, 4Fh			;056A  E5 4F
	CJNE	A, 4h, _0575		;056C  B5 04 06
	MOV	64h, #9Dh		;056F  75 64 9D
	LJMP	_16F2			;0572  02 16 F2
_0575:	MOV	30h, 4Eh		;0575  85 4E 30
	MOV	31h, 4Fh		;0578  85 4F 31
	MOV	A, @R1			;057B  E7
	MOV	32h, A			;057C  F5 32
	MOV	78h, #6h		;057E  75 78 06
	LJMP	_0952			;0581  02 09 52

_0584		MOV A, 5Ah
		JZ _0596
		CJNE A, #23h, _058B
_058B		JNC _058F
		MOV A, #23h
_058F		MOV R6, A
		MOV DPTR, #1B7Ah
		LCALL _0E8D
_0596		RET

_0597		MOV A, 5Ah
		JZ _05BF
		MOV 66h, A
		LCALL Omti_DMAdrSet2
		MOV R3, #0h
		MOV R2, 5Ah
		DEC R2
		MOV R0, #0Ah
		LCALL Omti_DMAdrSet1
		MOV R5, #8Bh
		LCALL _0B5E
		LCALL Omti_DMAdrSet2
		NOP
		NOP
		NOP
		MOV R6, 5Ah
		MOV R7, #0h		; transfer 00.(5A) bytes
		LCALL MFM_ReadSctr
		LCALL _0DF8
_05BF		RET

_05C0		MOV A, LBA_Hi
	JB	ACC.0, _05F2		;05C2  20 E0 2D
	JNB	ACC.4, _05F2		;05C5  30 E4 2A
	ANL	A, #0Eh			;05C8  54 0E
	CLR	C			;05CA  C3
	RRC	A			;05CB  13
	JB	41h, _05DC		;05CC  20 41 0D
	SETB	41h			;05CF  D2 41
	NOP				;05D1  00
	NOP				;05D2  00
	NOP				;05D3  00
	MOVX	@DPTR, A		;05D4  F0
	MOV	R7, #0h			;05D5  7F 00
	MOV	64h, #0h		;05D7  75 64 00
	SJMP	_05F1			;05DA  80 15
_05DC:	MOV	7Eh, A			;05DC  F5 7E
	NOP				;05DE  00
	NOP				;05DF  00
	NOP				;05E0  00
	MOVX	A, @DPTR		;05E1  E0
	CJNE	A, 7Eh, _05EC		;05E2  B5 7E 07
	MOV	R7, #0h			;05E5  7F 00
	MOV	64h, #0h		;05E7  75 64 00
	SJMP	_05F1			;05EA  80 05
_05EC:	MOV	R7, #6h			;05EC  7F 06
	MOV	64h, #6h		;05EE  75 64 06
_05F1:	RET				;05F1  22
_05F2:	MOV	R7, #2h			;05F2  7F 02
	MOV	64h, #4h		;05F4  75 64 04
	RET				;05F7  22

_05F8		MOV A, LBA_Hi
	JB	ACC.0, _0620		;05FA  20 E0 23
	JNB	ACC.4, _0620		;05FD  30 E4 20
	ANL	A, #0Eh			;0600  54 0E
	CLR	C			;0602  C3
	RRC	A			;0603  13
	MOV	7Eh, A			;0604  F5 7E
	NOP				;0606  00
	NOP				;0607  00
	NOP				;0608  00
	MOVX	A, @DPTR		;0609  E0
	CJNE	A, 7Eh, _0619		;060A  B5 7E 0C
	CLR	41h			;060D  C2 41
	MOV	A, #0FFh		;060F  74 FF
	MOVX	@DPTR, A		;0611  F0
	MOV	R7, #0h			;0612  7F 00
	MOV	64h, #0h		;0614  75 64 00
	SJMP	_05F1			;0617  80 D8
_0619:	MOV	R7, #6h			;0619  7F 06
	MOV	64h, #0h		;061B  75 64 00
	SJMP	_0625			;061E  80 05
_0620:	MOV	R7, #2h			;0620  7F 02
	MOV	64h, #4h		;0622  75 64 04
_0625:	RET				;0625  22

_0626		RET

_0627		MOV A, 5Ah
	JZ	_066F			;0629  60 44
	CJNE	A, #18h, _062E		;062B  B4 18 00
_062E:	JC	_0632			;062E  40 02
	MOV	A, #18h			;0630  74 18
_0632:	MOV	R6, A			;0632  FE
	LCALL	_0DAD			;0633  12 0D AD
	NOP				;0636  00
	NOP				;0637  00
	NOP				;0638  00
	MOVX	@DPTR, A		;0639  F0
	NOP				;063A  00
	NOP				;063B  00
	NOP				;063C  00
	MOV	A, B			;063D  E5 F0
	MOVX	@DPTR, A		;063F  F0
	LCALL	_082E			;0640  12 08 2E
	NOP				;0643  00
	NOP				;0644  00
	NOP				;0645  00
	MOV	A, R2			;0646  EA
	ADD	A, #1h			;0647  24 01
	MOVX	@DPTR, A		;0649  F0
	NOP				;064A  00
	NOP				;064B  00
	NOP				;064C  00
	MOV	A, R3			;064D  EB
	ADDC	A, #0h			;064E  34 00
	MOVX	@DPTR, A		;0650  F0
	MOV	A, #4h			;0651  74 04
	LCALL	Get_PositionVar
	NOP				;0656  00
	NOP				;0657  00
	NOP				;0658  00
	MOVX	@DPTR, A		;0659  F0
	MOV	A, #5h			;065A  74 05
	LCALL	Get_PositionVar
	INC	DPTR			;065F  A3
	MOVX	@DPTR, A		;0660  F0
	MOV	A, #6h			;0661  74 06
	LCALL	Get_PositionVar
	INC	DPTR			;0666  A3
	INC	A			;0667  04
	MOVX	@DPTR, A		;0668  F0
	NOP				;0669  00
	NOP				;066A  00
	NOP				;066B  00
	LCALL	_0EC6			;066C  12 0E C6
_066F:	RET				;066F  22

_0670		RET

_0671		MOV A, 5Eh
	LCALL	_0DAD			;0673  12 0D AD
	MOV	R0, #30h		;0676  78 30
	MOV	R7, #8h			;0678  7F 08
_067A:	MOV	@R0, #0h		;067A  76 00
	INC	R0			;067C  08
	DJNZ	R7, _067A		;067D  DF FB
	MOV	R0, #32h		;067F  78 32
	MOV	@R0, B			;0681  A6 F0
	INC	R0			;0683  08
	MOV	@R0, A			;0684  F6
	LCALL	_082E			;0685  12 08 2E
	MOV	A, R2			;0688  EA
	MOV	B, R3			;0689  8B F0
	ADD	A, #1h			;068B  24 01
	XCH	A, B			;068D  C5 F0
	ADDC	A, #0h			;068F  34 00
	XCH	A, B			;0691  C5 F0
	MOV	R0, #36h		;0693  78 36
	MOV	@R0, B			;0695  A6 F0
	INC	R0			;0697  08
	MOV	@R0, A			;0698  F6
	MOV	R2, #8h			;0699  7A 08
	MOV	R0, #30h		;069B  78 30
	LCALL	_0EAA			;069D  12 0E AA
	RET				;06A0  22

_06A1		RET

_06A2		LCALL _06DA
_06A5		MOV A, 5Dh
		JZ _06B6
		LCALL _03E7
		MOV 5Ah, #0h
		DJNZ 5Dh, _06A5
		LCALL _03E7
		RET
_06B6		MOV A, 5Eh
		JZ _06BD
		LCALL _03E7
_06BD		RET

_06BE		LCALL _06DA
_06C1:	MOV	A, 5Dh			;06C1  E5 5D
	JZ	_06D2			;06C3  60 0D
	LCALL	_03F8			;06C5  12 03 F8
	MOV	5Ah, #0h		;06C8  75 5A 00
	DJNZ	5Dh, _06C1		;06CB  D5 5D F3
	LCALL	_03F8			;06CE  12 03 F8
	RET				;06D1  22
_06D2:	MOV	A, 5Eh			;06D2  E5 5E
	JZ	_06BD			;06D4  60 E7
	LCALL	_03F8			;06D6  12 03 F8
	RET				;06D9  22
_06DA:	MOV	LBA_Hi, LBA_Lo		;06DA  85 59 57
	MOV	LBA_Mi, 5Ah		;06DD  85 5A 58
	MOV	LBA_Lo, 5Bh		;06E0  85 5B 59
	MOV	5Ah, 5Eh		;06E3  85 5E 5A
	RET				;06E6  22

_06E7		RET

_06E8		SETB 6Fh
		LJMP _06A2

_06ED:		LJMP _0480

_06F0:		MOV R5, #89h
		LJMP _06F7

_06F5		MOV R5,#8Bh
_06F7		LJMP _0B1B


_06FA:		MOV R0, #0E2h
	MOV	A, #2h			;06FC  74 02
	MOVX	@R0, A			;06FE  F2
	MOV	R7, #9h			;06FF  7F 09
	MOV	R1, #30h		;0701  79 30
	MOV	R0, #0E7h		;0703  78 E7
	MOVX	A, @R0			;0705  E2
	CLR	72h			;0706  C2 72
_0708:	SETB	34h			;0708  D2 34
	LCALL	_0BE5			;070A  12 0B E5
_070D:	JBC	76h, _0712		;070D  10 76 02
	SJMP	_070D			;0710  80 FB
_0712:	MOVX	A, @R0			;0712  E2
	MOV	@R1, A			;0713  F7
	INC	R1			;0714  09
	DJNZ	R7, _0708		;0715  DF F1
	MOV	R0, #0E6h		;0717  78 E6
	SETB	34h			;0719  D2 34
	LCALL	_0BE5			;071B  12 0B E5
_071E:	JBC	76h, _0723		;071E  10 76 02
	SJMP	_071E			;0721  80 FB
_0723:	MOVX	A, @R0			;0723  E2
	MOV	@R1, A			;0724  F7
	MOV	R0, #0E1h		;0725  78 E1
	MOV	A, #5h			;0727  74 05
	MOVX	@R0, A			;0729  F2
	MOV	R0, #0E2h		;072A  78 E2
	MOV	A, #82h			;072C  74 82
	MOVX	@R0, A			;072E  F2
	MOV	A, #4h			;072F  74 04
	ADD	A, #GeometryStart
	MOV	R0, A			;0733  F8
	MOV	@R0, 34h		;0734  A6 34
	INC	R0			;0736  08
	MOV	@R0, 35h		;0737  A6 35
	INC	R0			;0739  08
	MOV	@R0, 33h		;073A  A6 33
	INC	R0			;073C  08
	MOV	@R0, VolumeSizeH
	INC	R0			;073F  08
	MOV	A, 37h			;0740  E5 37
	ANL	A, #3h			;0742  54 03
	MOV	@R0, A			;0744  F6
	INC	R0			;0745  08
	RET				;0746  22

_0747		SETB 7Dh
		LCALL _17D0
		JNB F0, _0755
		MOV 64h, #40h
		LJMP _16F2
_0755		CLR 7Dh
		MOV 64h, #0h
		RET

_075B		MOV 78h, #0Ah
_075E:	MOV	4Ch, #1h		;075E  75 4C 01
	MOV	52h, 4Ch		;0761  85 4C 52
	LCALL	_0F19			;0764  12 0F 19
	JNB	F0, _0774		;0767  30 D5 0A
	MOV	A, 46h			;076A  E5 46
	CJNE	A, #11h, _0783		;076C  B4 11 14
	MOV	A, #8Dh			;076F  74 8D
	LCALL	_0B5E			;0771  12 0B 5E
_0774:	DEC	5Ah			;0774  15 5A
	MOV	A, 5Ah			;0776  E5 5A
	JZ	_0782			;0778  60 08
	LCALL	_12CC			;077A  12 12 CC
	JB	F0, _0783		;077D  20 D5 03
	SJMP	_075E			;0780  80 DC
_0782:	RET				;0782  22
_0783:	LJMP	_16F2			;0783  02 16 F2

_0786		MOV 49h, #1h
	LCALL	_1D08			;0789  12 1D 08
_078C:	LCALL	_10C4			;078C  12 10 C4
	SETB	6Dh			;078F  D2 6D
	LCALL	_137A			;0791  12 13 7A
	JB	F0, _07A7		;0794  20 D5 10
	MOV	R0, #26h		;0797  78 26
	MOVX	A, @R0			;0799  E2
	MOV	R5, A			;079A  FD
	MOV	A, #2h			;079B  74 02
	ADD	A, #GeometryStart
	MOV	R0, A			;079F  F8
	MOV	A, R5			;07A0  ED
	MOV	@R0, A			;07A1  F6
	MOV	R1, #GeometryStart
	LJMP	_0AF0			;07A4  02 0A F0
_07A7:	LCALL	_16B1			;07A7  12 16 B1
	JNB	F0, _07AF		;07AA  30 D5 02
	MOV	R7, #14h		;07AD  7F 14
_07AF:	MOV	A, 5Bh			;07AF  E5 5B
	ANL	A, #80h			;07B1  54 80
	JNZ	_07CE			;07B3  70 19
	MOV	A, R7			;07B5  EF
	CJNE	A, #15h, _07BB		;07B6  B4 15 02
	SJMP	_07C3			;07B9  80 08
_07BB:	DEC	49h			;07BB  15 49
	MOV	A, 49h			;07BD  E5 49
	JZ	_07CE			;07BF  60 0D
	SJMP	_07CC			;07C1  80 09
_07C3:	DEC	7Dh			;07C3  15 7D
	MOV	A, 7Dh			;07C5  E5 7D
	JZ	_07CE			;07C7  60 05
	CJNE	A, #4h, _07CC		;07C9  B4 04 00
_07CC:	SJMP	_078C			;07CC  80 BE
_07CE:	LJMP	_16F2			;07CE  02 16 F2

_07D1		LCALL OmtiInit_3
		JB ErrorFlag, _07DB
		MOV 64h, #0h
		RET
_07DB		MOV 64h, #4Ch
		LJMP _16F2

_07E1		RET

_07E2		MOV 78h, #9h
		LJMP _075E
_07E8		MOV 78h, #2h
		LJMP _07F1
_07EE		MOV 78h, #2h
_07F1		LCALL	_10E8
		RET

_07F5:	MOV	DPTR, #XRAMstart		; *** dead?
	MOV	R5, #20h		;07F8  7D 20
_07FA:	MOV	R4, #0Fh		;07FA  7C 0F
_07FC:	MOVX	A, @DPTR		;07FC  E0
	LCALL	SplitHex			;07FD  12 25 CF
	LCALL	Ser_SendChar			;0800  12 26 11
	MOV	A, B			;0803  E5 F0
	LCALL	Ser_SendChar			;0805  12 26 11
	INC	DPTR			;0808  A3
	MOV	A, #20h			;0809  74 20
	LCALL	Ser_SendChar			;080B  12 26 11
	DJNZ	R4, _07FC		;080E  DC EC
	MOV	A, #0Ah			;0810  74 0A
	LCALL	Ser_SendChar			;0812  12 26 11
	MOV	A, #0Dh			;0815  74 0D
	LCALL	Ser_SendChar			;0817  12 26 11
	DJNZ	R5, _07FA		;081A  DD DE
	RET				;081C  22

_081D		LCALL _0C37
		MOV DPTR, #082Ah
		MOVC A, @A+DPTR
		MOV 67h, A
_0826		MOV R0, #OmtiDS_SctrSBC
		MOVX @R0, A			; subblocks per sector
		RET

_082A		DB 07Fh, 03Fh, 084h, 0FFh

_082E:	PUSH	DPH			;082E  C0 83
	PUSH	DPL			;0830  C0 82
	MOV	A, #4h			;0832  74 04
	MOV	B, 67h			;0834  85 67 F0
	MUL	AB			;0837  A4
	ORL	A, #3h			;0838  44 03
	MOV	R2, A			;083A  FA
	MOV	R3, B			;083B  AB F0
	POP	DPL			;083D  D0 82
	POP	DPH			;083F  D0 83
	RET				;0841  22
_0842:	LCALL	_1D08			;0842  12 1D 08
	LCALL	_09E9			;0845  12 09 E9
_0848:	LCALL	_0852			;0848  12 08 52
	LCALL	_0905			;084B  12 09 05
	LCALL	_0933			;084E  12 09 33
	RET				;0851  22
_0852:	MOV	A, 5Ah			;0852  E5 5A
	CJNE	A, #0h, _0859		;0854  B4 00 02
	INC	5Ah			;0857  05 5A
_0859:	MOV	B, 5Ah			;0859  85 5A F0
	MOV	A, #2h			;085C  74 02
	ADD	A, #GeometryStart
	MOV	R1, A			;0860  F9
	MOV	A, @R1			;0861  E7
	ORL	A, 76h			;0862  45 76
	MOV	@R1, A			;0864  F7
	INC	R1			;0865  09
	MOV	@R1, #0h		;0866  77 00
	MOV	A, R1			;0868  E9
	ADD	A, #4h			;0869  24 04
	MOV	R1, A			;086B  F9
	MOV	A, @R1			;086C  E7
	INC	A			;086D  04
	MOV	R4, A			;086E  FC
	MOV	R7, #3Bh		;086F  7F 3B
	CJNE	A, 5Ah, _087A		;0871  B5 5A 06
	LJMP	_087C			;0874  02 08 7C
_0877:	LJMP	_16F2			;0877  02 16 F2
_087A:	JC	_0877			;087A  40 FB
_087C:	MOV	A, B			;087C  E5 F0
	RL	A			;087E  23
	RL	A			;087F  23
	MOV	B, A			;0880  F5 F0
	MOV	R3, #5h			;0882  7B 05
	MOV	R2, #0h			;0884  7A 00
	LCALL	Omti_DMAdrSet
	MOV	DPTR, #EXTI1		;0889  90 00 13
	MOV	A, #33h			;088C  74 33
	MOVX	@DPTR, A		;088E  F0
	MOV	DPTR, #28h		;088F  90 00 28
_0892:	MOV	R0, #GeometryStart
	MOV	R7, #4h			;0894  7F 04
_0896:	MOV	A, @R0			;0896  E6
	MOVX	@DPTR, A		;0897  F0
	INC	R0			;0898  08
	DJNZ	R7, _0896		;0899  DF FB
	DJNZ	R4, _0892		;089B  DC F5
	MOV	A, @R1			;089D  E7
	INC	A			;089E  04
	RL	A			;089F  23
	RL	A			;08A0  23
	MOV	R5, A			;08A1  FD
	MOV	R3, #5h			;08A2  7B 05
	MOV	R2, #3h			;08A4  7A 03
_08A6:	LCALL	Omti_DMAdr3Set
	MOV	DPTR, #28h		;08A9  90 00 28
	MOV	A, R4			;08AC  EC
	MOVX	@DPTR, A		;08AD  F0
	INC	R4			;08AE  0C
	MOV	A, @R1			;08AF  E7
	CJNE	A, 4h, _08B6		;08B0  B5 04 03
	LJMP	_08B8			;08B3  02 08 B8
_08B6:	JC	_08FE			;08B6  40 46
_08B8:	MOV	A, R2			;08B8  EA
	ADD	A, B			;08B9  25 F0
	MOV	R2, A			;08BB  FA
	MOV	A, R3			;08BC  EB
	ADDC	A, #0h			;08BD  34 00
	MOV	R3, A			;08BF  FB
	MOV	A, #5h			;08C0  74 05
	CJNE	A, 3h, _08C7		;08C2  B5 03 02
	SJMP	_08C9			;08C5  80 02
_08C7:	JC	_08D2			;08C7  40 09
_08C9:	MOV	A, R2			;08C9  EA
	CJNE	A, 5h, _08D0		;08CA  B5 05 03
	LJMP	_08A6			;08CD  02 08 A6
_08D0:	JC	_08A6			;08D0  40 D4
_08D2:	MOV	A, R2			;08D2  EA
	SUBB	A, R5			;08D3  9D
	MOV	R2, A			;08D4  FA
	MOV	A, R3			;08D5  EB
	SUBB	A, #0h			;08D6  94 00
	MOV	R3, A			;08D8  FB
	MOV	A, R2			;08D9  EA
	CJNE	A, #3h, _08E0		;08DA  B4 03 03
	ADD	A, #4h			;08DD  24 04
	MOV	R2, A			;08DF  FA
_08E0:	LCALL	Omti_DMAdr3Set
	MOV	DPTR, #OmtiMC_Ch3Ctrl
	MOV	A, #31h			;08E6  74 31
	MOVX	@DPTR, A		;08E8  F0
	MOV	DPTR, #28h		;08E9  90 00 28
	MOVX	A, @DPTR		;08EC  E0
	NOP				;08ED  00
	MOVX	A, @DPTR		;08EE  E0
	JZ	_08F5			;08EF  60 04
	MOV	A, R2			;08F1  EA
	ADD	A, #4h			;08F2  24 04
	MOV	R2, A			;08F4  FA
_08F5:	MOV	A, #33h			;08F5  74 33
	MOV	DPTR, #OmtiMC_Ch3Ctrl
	MOVX	@DPTR, A		;08FA  F0
	LJMP	_08A6			;08FB  02 08 A6
_08FE:	MOV	DPTR, #10h		;08FE  90 00 10
	MOV	A, #31h			;0901  74 31
	MOVX	@DPTR, A		;0903  F0
	RET				;0904  22
_0905:	MOV	A, #7h			;0905  74 07
	ADD	A, #GeometryStart
	MOV	R1, A			;0909  F9
	MOV	7Ah, @R1		;090A  87 7A
	INC	7Ah			;090C  05 7A
	MOV	R0, #21h		;090E  78 21
	MOV	A, 7Ah			;0910  E5 7A
	MOVX	@R0, A			;0912  F2
	LCALL	_10E1			;0913  12 10 E1
	MOV	R0, #29h		;0916  78 29
	MOV	R1, #2Eh		;0918  79 2E
	MOV	A, #8h			;091A  74 08
	MOVX	@R0, A			;091C  F2
	MOV	A, #0Ch			;091D  74 0C
	MOVX	@R1, A			;091F  F3
	MOV	A, 67h			;0920  E5 67
	CJNE	A, #0FFh, _092B		;0922  B4 FF 06
	MOV	A, #0Eh			;0925  74 0E
	MOVX	@R0, A			;0927  F2
	MOV	A, #16h			;0928  74 16
	MOVX	@R1, A			;092A  F3
_092B:	MOV	A, #21h			;092B  74 21
	MOV	R0, #29h		;092D  78 29
	MOVX	@R0, A			;092F  F2
	LJMP	_10D1			;0930  02 10 D1
_0933:	MOV	R4, #0FFh		;0933  7C FF
_0935:	MOV	R5, #0FFh		;0935  7D FF
_0937:	MOV	R6, #0Ah		;0937  7E 0A
_0939:	JNB	INT0, _094B		;0939  30 B2 0F
	DJNZ	R6, _0939		;093C  DE FB
	DJNZ	R5, _0937		;093E  DD F7
	DJNZ	R4, _0935		;0940  DC F3
	LCALL	OmtiInit_32
	MOV	64h, #1h		;0945  75 64 01
	LJMP	_16F2			;0948  02 16 F2
_094B:	RET				;094B  22

_094C		LJMP _16EC

_094F:	LJMP	_16F2			;094F  02 16 F2
_0952:	LCALL	_1DA6			;0952  12 1D A6
		LCALL Do_Seek
	LCALL	_09E9			;0958  12 09 E9
	LCALL	_137A			;095B  12 13 7A
	JC	_096B			;095E  40 0B
	LCALL	_1730			;0960  12 17 30
	JB	F0, _096B		;0963  20 D5 05
	MOV	64h, #9Dh		;0966  75 64 9D
	JC	_094F			;0969  40 E4
_096B:	MOV	76h, #20h		;096B  75 76 20
	LCALL	_0848			;096E  12 08 48
	LCALL	_0CB4			;0971  12 0C B4
	MOV	B, #2Fh			;0974  75 F0 2F
	MOV	A, #0Bh			;0977  74 0B
	MOV	R5, #4Eh		;0979  7D 4E
	LCALL	_0A01			;097B  12 0A 01
	MOV	5Ah, #0h		;097E  75 5A 00
	MOV	A, 5Bh			;0981  E5 5B
	ANL	A, #0BFh		;0983  54 BF
	MOV	5Bh, A			;0985  F5 5B
	MOV	76h, #0C0h		;0987  75 76 C0
	LCALL	_1DA6			;098A  12 1D A6
	LCALL	_1D08			;098D  12 1D 08
	LCALL	_09E9			;0990  12 09 E9
	LCALL	_137A			;0993  12 13 7A
	JC	_09A4			;0996  40 0C
	MOV	A, R5			;0998  ED
	ANL	A, #0E0h		;0999  54 E0
	CJNE	A, #20h, _09A4		;099B  B4 20 06
	MOV	64h, #3Fh		;099E  75 64 3F
	LJMP	_16F2			;09A1  02 16 F2
_09A4:	LCALL	_0848			;09A4  12 08 48
	LCALL	OmtiInit_32
	LCALL	_1156			;09AA  12 11 56
	DEC	7Bh			;09AD  15 7B
	MOV	R1, 7Bh			;09AF  A9 7B
	MOV	A, @R1			;09B1  E7
	ANL	A, #1Fh			;09B2  54 1F
	MOV	@R1, A			;09B4  F7
	MOV	4Ch, 7Ch		;09B5  85 7C 4C
	LCALL	Omti_DMAdrSet2
	MOV	R5, 7Ch			;09BB  AD 7C
_09BD:	MOV	R1, #30h		;09BD  79 30
	MOV	R7, #3h			;09BF  7F 03
	LCALL	_0D24			;09C1  12 0D 24
	DJNZ	R5, _09BD		;09C4  DD F7
	LCALL	_09F2			;09C6  12 09 F2
	SETB	6Fh			;09C9  D2 6F
	MOV	78h, #22h		;09CB  75 78 22
_09CE:	LCALL	Omti_DMAdrSet2
	LCALL	_0F2A			;09D1  12 0F 2A
	JNC	_09E2			;09D4  50 0C
	LCALL	_1156			;09D6  12 11 56
	MOV	R1, 7Bh			;09D9  A9 7B
	INC	@R1			;09DB  07
	DEC	4Ch			;09DC  15 4C
	MOV	A, 4Ch			;09DE  E5 4C
	JNZ	_09CE			;09E0  70 EC
_09E2:	MOV	A, 67h			;09E2  E5 67
	MOV	R5, #4h			;09E4  7D 04
	LJMP	_09F6			;09E6  02 09 F6
_09E9:	MOV	A, #3h			;09E9  74 03
	ADD	A, #GeometryStart
	MOV	R0, A			;09ED  F8
	MOV	A, @R0			;09EE  E6
	LJMP	_1362			;09EF  02 13 62
_09F2:	MOV	A, #0h			;09F2  74 00
	MOV	R5, #3h			;09F4  7D 03
_09F6:	LCALL	_0826			;09F6  12 08 26
	MOV	B, #2Eh			;09F9  75 F0 2E
	MOV	A, #0Bh			;09FC  74 0B
	LJMP	_0A01			;09FE  02 0A 01
_0A01:	MOV	R1, #29h		;0A01  79 29
	MOVX	@R1, A			;0A03  F3
	MOV	R1, B			;0A04  A9 F0
	MOV	A, R5			;0A06  ED
	MOVX	@R1, A			;0A07  F3
	MOV	R1, #29h		;0A08  79 29
	MOV	A, #33h			;0A0A  74 33
	MOVX	@R1, A			;0A0C  F3
	RET				;0A0D  22


; ***
; *** calculate block address of (bad block) sector indexed by
; *** cylinder (tmp_Cyl4..tmp_Cyl1) & head (tmp_hd )
; ***
;
Calculate_LBA	MOV A, #7h
		LCALL Get_PositionVar		; get NumberOf_Sec
		INC A				; +1
		PUSH Acc
		MOV A, #6h
		LCALL Get_PositionVar		; get NumberOf_Hd
		INC A				; + 1
		MOV B, A
		POP Acc
		MUL AB
		MOV R7, A			; sectors per cylinder in R7
		LCALL ConvToInteger		; convert bad cylinder digits to integer in R4.R5
		MOV A, R5
		SUBB A, #1h			; decrement by one
		MOV R5, A
		MOV A, R4
		SUBB A, #0h
		MOV R4, A
		MOV LBA_Hi, #0h			; zero LBA
		MOV LBA_Mi, #0h
		MOV LBA_Lo, #0h
_0A36		MOV A, LBA_Lo			; add cylinder number to LBA
		ADD A, R5
		MOV LBA_Lo, A
		MOV A, LBA_Mi
		ADDC A, R4
		MOV LBA_Mi, A
		MOV A, LBA_Hi
		ADDC A, #0h
		MOV LBA_Hi, A
		DJNZ R7, _0A36			; and repeat this Sec*Hd times
		MOV A, tmp_Hd			; get bad head digit
		SUBB A, #30h
		MOV B, 7Ch			; ??? sectors per track ???
		MUL AB
		MOV R5, A
		MOV A, LBA_Lo			; and add result to LBA
		ADD A, R5
		MOV LBA_Lo, A
		MOV A, LBA_Mi
		ADDC A, #0h
		MOV LBA_Mi, A
		MOV A, LBA_Hi
		ADDC A, #0h
		MOV LBA_Hi, A
		RET
;
; calculate integer value R4.R5 from digits in four byte buffer 41..tmp_Cyl4
ConvToInteger	MOV A, tmp_Cyl2		; 2nd digit of cylinder number
		SUBB A, #30h
		MOV B, #100
		MUL AB			; * 100
		MOV R4, B
		MOV R5, A
		LCALL ConvToInteger1	; calculate lower two digits
		ADD A, R5
		MOV R5, A
		MOV A, R4
		ADDC A, #0h
		MOV R4, A		; and add them to R4.R5
		MOV A, tmp_Cyl1		; get 1st digit
		SUBB A, #30h
		JZ ConvToInteger2	; done when zero
		MOV A, R5		; else add 1000
		ADD A, #1000 # 256
		MOV R5, A
		MOV A, R4
		ADDC A, #1000 / 256
		MOV R4, A
ConvToInteger2	RET
;
ConvToInteger1	MOV A, tmp_Cyl3		; 3rd digit of cylinder number
		SUBB A, #30h
		MOV B, #10
		MUL AB			; * 10
		MOV B, A
		MOV A, tmp_Cyl4
		SUBB A, #30h
		ADD A, B		; plus 4th digit
		RET




_0A97:	MOV	R1, #0E7h
	MOV	R0, #0E1h
	MOV	A, #84h
	MOVX	@R0, A			; 84h into 00E1h
	MOV	A, #85h
	MOVX	@R0, A			; 85 into 00E7h
	MOV	R0, #0E2h
	MOV	A, #2h
	MOVX	@R0, A			; 02 into 00E2h
	CLR	A
	PUSH	Acc
	MOV	A, 64h
	JZ	_0AB3			;0AAB  60 06
	POP	Acc			;0AAD  D0 E0
	SETB	Acc.1			;0AAF  D2 E1
	PUSH	Acc			;0AB1  C0 E0
_0AB3:	MOVX	A, @R0			;0AB3  E2
	ANL	A, #20h			;0AB4  54 20
	JZ	_0ABE			;0AB6  60 06
	POP	Acc			;0AB8  D0 E0
	SETB	Acc.1			;0ABA  D2 E1
	PUSH	Acc			;0ABC  C0 E0
_0ABE:	POP	Acc			;0ABE  D0 E0
	MOVX	@R1, A			;0AC0  F3
	MOV	R0, #0E1h		;0AC1  78 E1
	MOV	A, #86h			;0AC3  74 86
	SETB	34h			;0AC5  D2 34
	LCALL	_0BE5			;0AC7  12 0B E5
_0ACA:	JBC	76h, _0ACF		;0ACA  10 76 02
	SJMP	_0ACA			;0ACD  80 FB
_0ACF:	MOVX	@R0, A			;0ACF  F2
	MOV	A, 65h			;0AD0  E5 65
	MOVX	@R1, A			;0AD2  F3
	SETB	34h			;0AD3  D2 34
	LCALL	_0BE5			;0AD5  12 0B E5
_0AD8:	JBC	76h, _0ADD		;0AD8  10 76 02
	SJMP	_0AD8			;0ADB  80 FB
_0ADD:	RET				;0ADD  22

_0ADE		MOV 60h, 64h
	MOV	R1, #60h		;0AE1  79 60
	MOV	LBA_Hi1, #0h		;0AE3  75 61 00
	MOV	A, 5Ah			;0AE6  E5 5A
	JZ	_0AF0			;0AE8  60 06
	MOV	LBA_Mi1, 74h		;0AEA  85 74 62
	MOV	LBA_Lo1, #0h		;0AED  75 63 00
_0AF0:	MOV	R6, #4h			;0AF0  7E 04
	MOV	R0, #0E1h		;0AF2  78 E1
	MOV	A, #84h			;0AF4  74 84
	MOVX	@R0, A			;0AF6  F2
	MOV	R0, #0E2h		;0AF7  78 E2
	MOV	A, #2h			;0AF9  74 02
	MOVX	@R0, A			;0AFB  F2
	MOV	R0, #0E7h		;0AFC  78 E7
_0AFE:	MOV	A, @R1			;0AFE  E7
	MOVX	@R0, A			;0AFF  F2
	INC	R1			;0B00  09
	SETB	34h			;0B01  D2 34
	LCALL	_0BE5			;0B03  12 0B E5
_0B06:	JBC	76h, _0B0B		;0B06  10 76 02
	SJMP	_0B06			;0B09  80 FB
_0B0B:	DJNZ	R6, _0AFE		;0B0B  DE F1
	MOV	A, 5Ah			;0B0D  E5 5A
	JNZ	_0B12			;0B0F  70 01
	RET				;0B11  22
_0B12:	MOV	R6, #4h			;0B12  7E 04
	MOV	R1, #57h		;0B14  79 57
	MOV	5Ah, #0h		;0B16  75 5A 00
	SJMP	_0AFE			;0B19  80 E3

_0B1B		MOV 5Ah, #1h
	LCALL	_10E8			;0B1E  12 10 E8
	MOV	A, 79h			;0B21  E5 79
	CJNE	A, 5Ah, _0B28		;0B23  B5 5A 02
	SJMP	_0B2D			;0B26  80 05
_0B28:	MOV	64h, #21h		;0B28  75 64 21
	JC	_0B79			;0B2B  40 4C
_0B2D:	MOV	64h, #0h		;0B2D  75 64 00
	LCALL	Omti_DMAdrSet2
	LCALL	_082E			;0B33  12 08 2E
	MOV	R0, #0Ah		;0B36  78 0A
	LCALL	Omti_DMAdrSet1
	MOV	DPTR, #12h		;0B3B  90 00 12
	MOV	47h, R5			;0B3E  8D 47
_0B40:	MOV	26h, #0h		;0B40  75 26 00
	SETB	37h			;0B43  D2 37
	LCALL	_0BE5			;0B45  12 0B E5
	SETB	69h			;0B48  D2 69
	MOV	7Ah, #1h		;0B4A  75 7A 01
	MOV	A, 47h			;0B4D  E5 47
	MOVX	@DPTR, A		;0B4F  F0
_0B50:	JB	69h, _0B50		;0B50  20 69 FD
	MOV	A, #80h			;0B53  74 80
	MOVX	@R0, A			;0B55  F2
	MOV	A, 5Ah			;0B56  E5 5A
	DEC	A			;0B58  14
	MOV	5Ah, A			;0B59  F5 5A
	JNZ	_0B40			;0B5B  70 E3
	RET				;0B5D  22

_0B5E		SETB 69h
	MOV	7Ah, #1h		;0B60  75 7A 01
	MOV	26h, #0h		;0B63  75 26 00
	SETB	37h			;0B66  D2 37
	LCALL	_0BE5			;0B68  12 0B E5
	MOV	DPTR, #12h		;0B6B  90 00 12
	MOV	47h, R5			;0B6E  8D 47
	MOV	A, R5			;0B70  ED
	MOVX	@DPTR, A		;0B71  F0
_0B72:	JB	69h, _0B72		;0B72  20 69 FD
	MOV	A, #80h			;0B75  74 80
	MOVX	@DPTR, A		;0B77  F0
	RET				;0B78  22

_0B79		LJMP _16F2

_0B7C		MOV DPTR, #8200h
	MOVX	A, @DPTR		;0B7F  E0
	CJNE	A, #0AAh, _0BB9		;0B80  B4 AA 36
	INC	DPTR			;0B83  A3
	MOVX	A, @DPTR		;0B84  E0
	MOV	R6, A			;0B85  FE
	MOV	R7, #0h			;0B86  7F 00
_0B88:	INC	DPTR			;0B88  A3
	MOVX	A, @DPTR		;0B89  E0
	CJNE	A, 56h, _0B92		;0B8A  B5 56 05
	MOV	A, R7			;0B8D  EF
	MOV	R5, A			;0B8E  FD
	LJMP	_0BBA			;0B8F  02 0B BA
_0B92:	INC	R7			;0B92  0F
	DJNZ	R6, _0B88		;0B93  DE F3
	RET				;0B95  22

_0B96:	MOV	DPTR, #8200h		; *** dead?
	MOVX	A, @DPTR		;0B99  E0
	CJNE	A, #0AAh, _0BB9		;0B9A  B4 AA 1C
	INC	DPTR			;0B9D  A3
	MOVX	A, @DPTR		;0B9E  E0
	LCALL	_0BD4			;0B9F  12 0B D4
	MOVX	A, @DPTR		;0BA2  E0
	MOV	R6, A			;0BA3  FE
	MOV	R7, #0h			;0BA4  7F 00
_0BA6:	INC	DPTR			;0BA6  A3
	MOVX	A, @DPTR		;0BA7  E0
	CJNE	A, 7Eh, _0BB6		;0BA8  B5 7E 0B
	MOV	DPTR, #8200h		;0BAB  90 82 00
	INC	DPTR			;0BAE  A3
	MOVX	A, @DPTR		;0BAF  E0
	CLR	C			;0BB0  C3
	ADD	A, R7			;0BB1  2F
	MOV	R5, A			;0BB2  FD
	LJMP	_0BBA			;0BB3  02 0B BA
_0BB6:	INC	R7			;0BB6  0F
	DJNZ	R6, _0BA6		;0BB7  DE ED
_0BB9		RET

_0BBA:	POP	ACC			;0BBA  D0 E0
	POP	ACC			;0BBC  D0 E0
	LCALL	_16E2			;0BBE  12 16 E2
	MOV	DPTR, #8200h		;0BC1  90 82 00
	INC	DPTR			;0BC4  A3
	MOVX	A, @DPTR		;0BC5  E0
	LCALL	_0BD4			;0BC6  12 0B D4
	MOVX	A, @DPTR		;0BC9  E0
	LCALL	_0BD4			;0BCA  12 0B D4
	MOV	A, R5			;0BCD  ED
	CLR	C			;0BCE  C3
	MOV	B, #3h			;0BCF  75 F0 03
	MUL	AB			;0BD2  A4
	JMP	@A+DPTR			;0BD3  73
_0BD4:	CLR	C			;0BD4  C3
	ADD	A, DPL			;0BD5  25 82
	MOV	DPL, A			;0BD7  F5 82
	MOV	A, DPH			;0BD9  E5 83
	ADDC	A, #0h			;0BDB  34 00
	MOV	DPH, A			;0BDD  F5 83
	RET				;0BDF  22

; read from GeometryStart + Acc
Get_PositionVar	ADD A, #GeometryStart
		MOV R0, A
		MOV A, @R0
		RET

_0BE5		PUSH DPH
		PUSH DPL
		PUSH Acc
		MOV A, 26h
		MOV DPTR, #0E0h
		MOVX @DPTR, A		; write 26h into 00E0h
		POP Acc
		POP DPL
		POP DPH
		SETB EX1		; and enable INT1 (from PCmd)
		RET

; ***
; *** set Ch 0, 2, 3 DMA address to 000Ah (bit 79 set) or 0000h (bit 79 cleared)
; ***
;
Omti_DMAdrSet2	MOV P2, #Omti_base
		JNB 79h, Omti_DMAdrSet3		; bit 79=1 -> DMA adress 000Ah
		MOV R2, #0h
		MOV R3, #0h
		SJMP Omti_DMAdrSet		; bit 79=0 -> DMA adress 0000h
Omti_DMAdrSet3	MOV R2, #0Ah
		MOV R3, #0h
;
; set Channel 0, 2, 3 DMA address to R3.R2
Omti_DMAdrSet	MOV R0, #OmtiMC_Ch0AdrL
		LCALL Omti_DMAdrSet1
;
; set Channel 2, 3 DMA address to R3.R2
Omti_DMAdr23Set	MOV R0, #OmtiMC_Ch2AdrL
		LCALL Omti_DMAdrSet1
;
; set Channel 3 DMA address to R3.R2
Omti_DMAdr3Set	MOV R0, #OmtiMC_Ch3AdrL
Omti_DMAdrSet1	MOV A, R2
		MOVX @R0, A
		MOV A, R3
		INC R0
		MOVX @R0, A
		RET


; ***
; *** Delay routine (R3.R2) = time
; ***
;
Delay		LCALL Delay1
		DJNZ R2, Delay
		DJNZ R3, Delay
		RET
Delay1		MOV R4, #32h
Delay3		MOV R5, #32h
Delay2		DJNZ R5, Delay2
		DJNZ R4, Delay3
		RET

_0C2D		ANL 2Fh, #0FBh
		MOV A, LBA_Hi
		ANL A, #60h
		LJMP _081D

_0C37		MOV A, #0Dh
		ADD A, #GeometryStart
		MOV R0, A
		MOV A, @R0		; get value from 75h
		ANL A, #3h		;  mask out lower 2 bits
		RET

_0C40:	CLR	ET0			; *** dead?
	MOV	R5, #0EEh		;0C42  7D EE
	MOV	R6, #0EEh		;0C44  7E EE
	MOV	R7, #50h		;0C46  7F 50
_0C48:	MOV	R0, #10h		;0C48  78 10
_0C4A:	CLR	TR0			;0C4A  C2 8C
	CLR	TF0			;0C4C  C2 8D
	MOV	TH0, #0BBh		;0C4E  75 8C BB
	MOV	TL0, #0AAh		;0C51  75 8A AA
	MOV	DPTR, #21h		;0C54  90 00 21
_0C57:	LCALL	_0C9B			;0C57  12 0C 9B
	MOVX	A, @DPTR		;0C5A  E0
	ANL	A, #80h			;0C5B  54 80
	JZ	_0C57			;0C5D  60 F8
_0C5F:	LCALL	_0C9B			;0C5F  12 0C 9B
	MOVX	A, @DPTR		;0C62  E0
	ANL	A, #80h			;0C63  54 80
	JNZ	_0C5F			;0C65  70 F8
	SETB	TR0			;0C67  D2 8C
_0C69:	LCALL	_0C9B			;0C69  12 0C 9B
	MOVX	A, @DPTR		;0C6C  E0
	ANL	A, #80h			;0C6D  54 80
	JZ	_0C69			;0C6F  60 F8
_0C71:	JB	TF0, _0C48		;0C71  20 8D D4
	LCALL	_0C9B			;0C74  12 0C 9B
	MOVX	A, @DPTR		;0C77  E0
	ANL	A, #80h			;0C78  54 80
	JNZ	_0C71			;0C7A  70 F5
	JB	TF0, _0C48		;0C7C  20 8D C9
	CLR	TR0			;0C7F  C2 8C
	MOV	A, TH0			;0C81  E5 8C
	CPL	A			;0C83  F4
	CJNE	A, #6h, _0C89		;0C84  B4 06 02
	SJMP	_0C8E			;0C87  80 05
_0C89:	JNC	_0C48			;0C89  50 BD
	LJMP	_0C96			;0C8B  02 0C 96
_0C8E:	MOV	A, TL0			;0C8E  E5 8A
	CPL	A			;0C90  F4
	CJNE	A, #82h, _0C94		;0C91  B4 82 00
_0C94:	JNC	_0C48			;0C94  50 B2
_0C96:	DJNZ	R0, _0C4A		;0C96  D8 B2
	CLR	F0			;0C98  C2 D5
	RET				;0C9A  22
_0C9B:	DJNZ	R5, _0CAB		;0C9B  DD 0E
	DJNZ	R6, _0CAC		;0C9D  DE 0D
	DJNZ	R7, _0CAF		;0C9F  DF 0E
	SETB	F0			;0CA1  D2 D5
	MOV	64h, #1h		;0CA3  75 64 01
	POP	ACC			;0CA6  D0 E0
	POP	ACC			;0CA8  D0 E0
	RET				;0CAA  22
_0CAB:	RET				;0CAB  22
_0CAC:	MOV	R5, #0FFh		;0CAC  7D FF
	RET				;0CAE  22
_0CAF:	MOV	R5, #0FFh		;0CAF  7D FF
	MOV	R6, #0FFh		;0CB1  7E FF
	RET				;0CB3  22

_0CB4:	PUSH	0h			;0CB4  C0 00
	PUSH	1h			;0CB6  C0 01
	MOV	R0, #57h		;0CB8  78 57
	MOV	R1, #5Ch		;0CBA  79 5C
	MOV	R7, #3h			;0CBC  7F 03
_0CBE:	MOV	A, @R0			;0CBE  E6
	PUSH	Acc			;0CBF  C0 E0
	MOV	A, @R1			;0CC1  E7
	MOV	@R0, A			;0CC2  F6
	POP	Acc			;0CC3  D0 E0
	MOV	@R1, A			;0CC5  F7
	INC	R0			;0CC6  08
	INC	R1			;0CC7  09
	DJNZ	R7, _0CBE		;0CC8  DF F4
	LCALL	_0C2D			;0CCA  12 0C 2D
	POP	1h			;0CCD  D0 01
	POP	0h			;0CCF  D0 00

; copy LBA into LBA1
LBAtoLBA1		MOV LBA_Hi1, LBA_Hi
		MOV LBA_Mi1, LBA_Mi
		MOV LBA_Lo1, LBA_Lo
		RET
;
_0CDB:	MOV	R2, #6h			;0CDB  7A 06
	MOV	R3, #0h			;0CDD  7B 00
	LCALL	Omti_DMAdr3Set			;0CDF  12 0C 14
	MOV	R1, #60h		;0CE2  79 60
	MOV	R7, #4h			;0CE4  7F 04
	LCALL	_0D24			;0CE6  12 0D 24
	RET				;0CE9  22


; ***
; *** get R7.R6 data bytes from disk via DMA channel 3
; *** bytes are complemented when bit 79 cleared
; ***
;
MFM_ReadSctr	MOV R1, #OmtiMC_Ch3Ctrl
		MOV A, #31h			; configure Ch 3 for Read
		MOVX @R1, A
		MOV R1, #OmtiDS_MemToMC
		MOVX A, @R1			; get dummy byte
		NOP
		CLR C
MFM_ReadSctr1	MOVX A, @R1			; get data byte,
		JB 79h, $+4
		CPL A				;  complement it if bit 79 = 0
		MOVX @DPTR, A			;  and store it into RAM
		INC DPTR
		MOV A, R6
		SUBB A, #1h
		MOV R6, A
		MOV A, R7
		SUBB A, #0h
		MOV R7, A			; decrement R7.R6
		MOV A, R6
		JNZ MFM_ReadSctr1		; and get next byte
		MOV A, R7
		JNZ MFM_ReadSctr1
		RET


; ***
; *** write R7.R6 data bytes to disk via DMA channel 3
; ***
;
MFM_WriteSctr	MOV R1, #OmtiMC_Ch3Ctrl
		MOV A, #33h
		MOVX @R1, A			; configure Ch 3 for Write
		MOV R1, #OmtiDS_MCtoMem
		CLR C
MFM_WriteSctr1	MOVX A, @DPTR			; get byte from RAM
		MOVX @R1, A			;  and store it into DMA channel
		INC DPTR
		MOV A, R6
		SUBB A, #1h
		MOV R6, A
		MOV A, R7
		SUBB A, #0h
		MOV R7, A			; decrement R7.R6
		MOV A, R6
		JNZ MFM_WriteSctr1		; and get next byte
		MOV A, R7
		JNZ MFM_WriteSctr1
		RET


_0D24	MOV	R0, #13h		;0D24  78 13
	MOV	A, #33h			;0D26  74 33
	MOVX	@R0, A			;0D28  F2
	MOV	R0, #28h		;0D29  78 28
_0D2B:	MOV	A, @R1			;0D2B  E7
	MOVX	@R0, A			;0D2C  F2
	INC	R1			;0D2D  09
	DJNZ	R7, _0D2B		;0D2E  DF FB
	RET				;0D30  22
_0D31:	MOV	R0, #13h		;0D31  78 13
	MOV	A, #31h			;0D33  74 31
	MOVX	@R0, A			;0D35  F2
	MOV	R0, #28h		;0D36  78 28
	MOVX	A, @R0			;0D38  E2
_0D39:	MOVX	A, @R0			;0D39  E2
	MOV	@R1, A			;0D3A  F7
	INC	R1			;0D3B  09
	DJNZ	R7, _0D39		;0D3C  DF FB
	RET				;0D3E  22

_0D3F:	MOV	R0, #13h		; *** dead?
	MOV	A, #31h			;0D41  74 31
	MOVX	@R0, A			;0D43  F2
	MOV	R0, #28h		;0D44  78 28
	MOVX	A, @R0			;0D46  E2
_0D47:	MOVX	A, @R0			;0D47  E2
	CPL	A			;0D48  F4
	MOV	@R1, A			;0D49  F7
	INC	R1			;0D4A  09
	DJNZ	R7, _0D47		;0D4B  DF FA
	RET				;0D4D  22

_0D4E		MOV R7, #2h
_0D50:	CLR	C			;0D50  C3
	RLC	A			;0D51  33
	XCH	A, B			;0D52  C5 F0
	RLC	A			;0D54  33
	XCH	A, B			;0D55  C5 F0
	DJNZ	R7, _0D50		;0D57  DF F7
	ADD	A, R1			;0D59  29
	XCH	A, B			;0D5A  C5 F0
	ADDC	A, #0h			;0D5C  34 00
	XCH	A, B			;0D5E  C5 F0
	LCALL	_0D6B			;0D60  12 0D 6B
	ADD	A, R2			;0D63  2A
	XCH	A, B			;0D64  C5 F0
	ADDC	A, #0h			;0D66  34 00
	XCH	A, B			;0D68  C5 F0
	RET				;0D6A  22
_0D6B:	MOV	R1, A			;0D6B  F9
	MOV	A, 6Fh			;0D6C  E5 6F
	INC	A			;0D6E  04
	CJNE	A, #9h, _0D76		;0D6F  B4 09 04
	CLR	F0			;0D72  C2 D5
	SJMP	_0D7B			;0D74  80 05
_0D76:	CJNE	A, #12h, _0DA0		;0D76  B4 12 27
	SETB	F0			;0D79  D2 D5
_0D7B:	MOV	A, R1			;0D7B  E9
	MOV	R7, #2h			;0D7C  7F 02
_0D7E:	MOV	R1, B			;0D7E  A9 F0
	MOV	B, #3h			;0D80  75 F0 03
	MUL	AB			;0D83  A4
	MOV	R3, A			;0D84  FB
	MOV	R4, B			;0D85  AC F0
	MOV	A, R1			;0D87  E9
	MOV	B, #3h			;0D88  75 F0 03
	MUL	AB			;0D8B  A4
	ADD	A, R4			;0D8C  2C
	MOV	B, A			;0D8D  F5 F0
	MOV	A, R3			;0D8F  EB
	DJNZ	R7, _0D7E		;0D90  DF EC
	JNB	F0, _0DAC		;0D92  30 D5 17
	CLR	F0			;0D95  C2 D5
	CLR	C			;0D97  C3
	RLC	A			;0D98  33
	XCH	A, B			;0D99  C5 F0
	RLC	A			;0D9B  33
	XCH	A, B			;0D9C  C5 F0
	SJMP	_0DAC			;0D9E  80 0C
_0DA0:	MOV	R7, #5h			;0DA0  7F 05
	MOV	A, R1			;0DA2  E9
_0DA3:	CLR	C			;0DA3  C3
	RLC	A			;0DA4  33
	XCH	A, B			;0DA5  C5 F0
	RLC	A			;0DA7  33
	XCH	A, B			;0DA8  C5 F0
	DJNZ	R7, _0DA3		;0DAA  DF F7
_0DAC:	RET				;0DAC  22

_0DAD		PUSH DPH
	PUSH	DPL			;0DAF  C0 82
	MOV	A, NumberOf_CylL			;0DB1  E5 6D
	MOV	B, NumberOf_CylH			;0DB3  85 6C F0
	MOV	R1, NumberOf_Hd			;0DB6  A9 6E
	MOV	R2, NumberOf_Sec			;0DB8  AA 6F
	LCALL	_0D4E			;0DBA  12 0D 4E
	ADD	A, #1h			;0DBD  24 01
	XCH	A, B			;0DBF  C5 F0
	ADDC	A, #0h			;0DC1  34 00
	XCH	A, B			;0DC3  C5 F0
	POP	DPL			;0DC5  D0 82
	POP	DPH			;0DC7  D0 83
	RET				;0DC9  22

_0DCA:	PUSH	DPH			; *** dead?
	PUSH	DPL			;0DCC  C0 82
		MOV DPTR, #_1C5D
	MOV	R7, #3Fh		;0DD1  7F 3F
	NOP				;0DD3  00
	NOP				;0DD4  00
	NOP				;0DD5  00
	NOP				;0DD6  00
	NOP				;0DD7  00
_0DD8:	CLR	A			;0DD8  E4
	MOVC	A, @A+DPTR		;0DD9  93
	MOVX	@R0, A			;0DDA  F2
	INC	DPTR			;0DDB  A3
	INC	R0			;0DDC  08
	DJNZ	R7, _0DD8		;0DDD  DF F9
		MOV DPTR, #RAMinit_Table1
	NOP				;0DE2  00
	NOP				;0DE3  00
	NOP				;0DE4  00
	NOP				;0DE5  00
	NOP				;0DE6  00
	MOV	R7, #3h			;0DE7  7F 03
_0DE9:	CLR	A			;0DE9  E4
	MOVC	A, @A+DPTR		;0DEA  93
	MOVX	@R0, A			;0DEB  F2
	INC	DPTR			;0DEC  A3
	INC	R0			;0DED  08
	DJNZ	R7, _0DE9		;0DEE  DF F9
	MOV	P2, #0h			;0DF0  75 A0 00
	POP	DPL			;0DF3  D0 82
	POP	DPH			;0DF5  D0 83
	RET				;0DF7  22

_0DF8		MOV R7, #4h
	NOP				;0DFA  00
	NOP				;0DFB  00
	NOP				;0DFC  00
	MOVX	A, @DPTR		;0DFD  E0
	JZ	_0E00			;0DFE  60 00
_0E00:	INC	DPTR			;0E00  A3
	INC	R7			;0E01  0F
	MOVX	A, @DPTR		;0E02  E0
	NOP				;0E03  00
	NOP				;0E04  00
	NOP				;0E05  00
	JB	ACC.7, _0E14		;0E06  20 E7 0B
	NOP				;0E09  00
	NOP				;0E0A  00
	NOP				;0E0B  00
	NOP				;0E0C  00
	NOP				;0E0D  00
	LCALL	_0E76			;0E0E  12 0E 76
	LJMP	_0E68			;0E11  02 0E 68
_0E14:	NOP				;0E14  00
	NOP				;0E15  00
	NOP				;0E16  00
	NOP				;0E17  00
	NOP				;0E18  00
	PUSH	DPH			;0E19  C0 83
	PUSH	DPL			;0E1B  C0 82
	LCALL	_0E82			;0E1D  12 0E 82
	POP	DPL			;0E20  D0 82
	POP	DPH			;0E22  D0 83
	LJMP	_0E68			;0E24  02 0E 68

_0E27:	NOP				; *** dead?
	NOP				;0E28  00
	NOP				;0E29  00
	JB	ACC.7, _0E33		;0E2A  20 E7 06
	LCALL	_0E76			;0E2D  12 0E 76
	LJMP	_0E68			;0E30  02 0E 68
_0E33:	PUSH	DPH			;0E33  C0 83
	PUSH	DPL			;0E35  C0 82
	MOV	DPTR, #1C81h		;0E37  90 1C 81
	LCALL	_0E82			;0E3A  12 0E 82
	POP	DPL			;0E3D  D0 82
	POP	DPH			;0E3F  D0 83
	LJMP	_0E68			;0E41  02 0E 68

_0E44:	NOP				;0E44  00	dead?
	NOP				;0E45  00
	NOP				;0E46  00
	JB	ACC.7, _0E55		;0E47  20 E7 0B
	NOP				;0E4A  00
	NOP				;0E4B  00
	NOP				;0E4C  00
	NOP				;0E4D  00
	NOP				;0E4E  00
	LCALL	_0E76			;0E4F  12 0E 76
	LJMP	_0E68			;0E52  02 0E 68
_0E55:	NOP				;0E55  00
	NOP				;0E56  00
	NOP				;0E57  00
	NOP				;0E58  00
	NOP				;0E59  00
	PUSH	DPH			;0E5A  C0 83
	PUSH	DPL			;0E5C  C0 82
	MOV DPTR, #_1C8C
	LCALL	_0E82			;0E61  12 0E 82
	POP	DPL			;0E64  D0 82
	POP	DPH			;0E66  D0 83
_0E68:	MOV	A, R7			;0E68  EF
	CJNE	A, 66h, _0E6C		;0E69  B5 66 00
_0E6C:	JNC	_0E71			;0E6C  50 03
	LJMP	_0E00			;0E6E  02 0E 00
_0E71:	MOV	P2, #0h			;0E71  75 A0 00
	RET				;0E74  22
_0E75		RET
_0E76:	INC	DPTR			;0E76  A3
	INC	R7			;0E77  0F
	MOVX	A, @DPTR		;0E78  E0
	MOV	R6, A			;0E79  FE
_0E7A:	INC	DPTR			;0E7A  A3
	INC	R7			;0E7B  0F
	MOVX	A, @DPTR		;0E7C  E0
	MOVX	@R0, A			;0E7D  F2
	INC	R0			;0E7E  08
	DJNZ	R6, _0E7A		;0E7F  DE F9
	RET				;0E81  22
_0E82:	MOVX	A, @R0			;0E82  E2
	MOV	R6, A			;0E83  FE
	INC	R0			;0E84  08
_0E85:	CLR	A			;0E85  E4
	MOVC	A, @A+DPTR		;0E86  93
	MOVX	@R0, A			;0E87  F2
	INC	R0			;0E88  08
	INC	DPTR			;0E89  A3
	DJNZ	R6, _0E85		;0E8A  DE F9
	RET				;0E8C  22

_0E8D		MOV R1, #0E1h
	MOV	A, #84h			;0E8F  74 84
	MOVX	@R1, A			;0E91  F3
	MOV	R1, #0E2h		;0E92  79 E2
	MOV	A, #2h			;0E94  74 02
	MOVX	@R1, A			;0E96  F3
	MOV	R1, #0E7h		;0E97  79 E7
_0E99:	CLR	A			;0E99  E4
	MOVC	A, @A+DPTR		;0E9A  93
	MOVX	@R1, A			;0E9B  F3
	INC	DPTR			;0E9C  A3
	SETB	34h			;0E9D  D2 34
	LCALL	_0BE5			;0E9F  12 0B E5
_0EA2:	JBC	76h, _0EA7		;0EA2  10 76 02
	SJMP	_0EA2			;0EA5  80 FB
_0EA7:	DJNZ	R6, _0E99		;0EA7  DE F0
	RET				;0EA9  22

_0EAA		MOV R1, #0E1h
	MOV	A, #84h			;0EAC  74 84
	MOVX	@R1, A			;0EAE  F3
	MOV	R1, #0E2h		;0EAF  79 E2
	MOV	A, #2h			;0EB1  74 02
	MOVX	@R1, A			;0EB3  F3
	MOV	R1, #0E7h		;0EB4  79 E7
_0EB6:	MOV	A, @R0			;0EB6  E6
	MOVX	@R1, A			;0EB7  F3
	INC	R0			;0EB8  08
	SETB	34h			;0EB9  D2 34
	LCALL	_0BE5			;0EBB  12 0B E5
_0EBE:	JBC	76h, _0EC3		;0EBE  10 76 02
	SJMP	_0EBE			;0EC1  80 FB
_0EC3:	DJNZ	R2, _0EB6		;0EC3  DA F1
	RET				;0EC5  22

_0EC6		MOV R1, #0E1h
	MOV	A, #84h			;0EC8  74 84
	MOVX	@R1, A			;0ECA  F3
	MOV	R1, #0E2h		;0ECB  79 E2
	MOV	A, #2h			;0ECD  74 02
	MOVX	@R1, A			;0ECF  F3
	MOV	R1, #0E7h		;0ED0  79 E7
_0ED2:	MOVX	A, @DPTR		;0ED2  E0
	MOVX	@R1, A			;0ED3  F3
	INC	DPTR			;0ED4  A3
	SETB	34h			;0ED5  D2 34
	LCALL	_0BE5			;0ED7  12 0B E5
_0EDA:	JBC	76h, _0EDF		;0EDA  10 76 02
	SJMP	_0EDA			;0EDD  80 FB
_0EDF:	DJNZ	R6, _0ED2		;0EDF  DE F1
	RET				;0EE1  22

SelectDrive1	SETB MFM_DriveSel
		RET

_0EE5		CLR 96h		; *** dead?
		RET

_0EE8		MOV 78h, #81h
		SJMP _0EF3


; perform block read
_0EED		JB 2Dh, _0EE8		; bit 2D = 1 -> 78h=#81h
		MOV 78h, #1h		; bit 2D = 0 -> 78h=#1
_0EF3		MOV 4Ch, 5Ah		; number of blocks?
		SJMP _0F01
; perform block write
_0EF8		MOV 78h, #2h		;  78h=#2
		MOV 4Ch, 5Ah
		MOV 52h, 4Ch
_0F01		MOV 26h, #0h
		JB 6Fh, _0F0C
		SETB 37h
		LCALL _0BE5
_0F0C		SETB 6Eh
		MOV 7Ah, #0h
		MOV 4Bh, 4Ch
		CLR 69h
		LCALL Omti_DMAdrSet2
_0F19		LCALL _1D08
		LCALL _082E
		MOV R0, #0Ah
		LCALL Omti_DMAdrSet1
		LCALL _10E1
_0F27		LCALL _10E8
_0F2A		LCALL _10FA
		LCALL _10C4
		MOV R1, #29h
		MOV DPH, #0h
		CLR EX1
		MOV A, 78h
		ANL A, #1h
		JZ _0F43
		LCALL _116D
		LJMP _0F46
_0F43		LCALL _1201
_0F46		JB F0, _0F61
		CLR C
		MOV A, 4Ch
		SUBB A, 48h
		MOV 4Ch, A
		JZ _0F54
		SJMP _0F57
_0F54		LJMP _1357
_0F57		LCALL _16E2
		LCALL _12D8
		JNB F0, _0F2A
		RET
_0F61		CLR C
		MOV A, 4Ch
		SUBB A, 48h
		MOV 4Ch, A
		LCALL LBAtoLBA1
_0F6B		MOV A, 46h
		ANL A, #80h
		JZ _0FD4
		MOV A, 45h
		ANL A, #4h
		JZ _0F95
		LCALL _16B1
		JB F0, _0FB0
		MOV A, 78h
		ANL A, #20h
		JNZ _0F8F
		LCALL _1730
		JB F0, _0F8F
		JNC _0F8C
		RET
_0F8C		LJMP _15BF
_0F8F		MOV 64h, #14h
		LJMP _0FB0
_0F95		MOV A, 45h
		ANL A, #8h
		JZ _0FA4
		LCALL _172D
		JB F0, _0FA4
		JNC _0F8C
		RET
_0FA4		MOV A, 45h
		ANL A, #10h
		JNZ _0FDA
_0FAA		MOV 64h, #4Ch
_0FAD		SETB F0
		RET
_0FB0		MOV A, 5Bh
		ANL A, #80h
		JNZ _0FAD
		MOV A, 64h
		CJNE A, #15h, _0FCB
		MOV A, 7Dh
		DEC A
		MOV 7Dh, A
		JZ _0FAD
		CJNE A, #4h, _0FC8
_0FC5		LCALL _1DA6
_0FC8		LJMP _0F19
_0FCB		LCALL _10AB
		JB F0, _0FAD
		LJMP _0FC5
_0FD4		MOV A, 46h
		ANL A, #4h
		JZ _0FE0
_0FDA		MOV 64h, #13h
		LJMP _0FF7
_0FE0		MOV A, 46h
		ANL A, #2h
		JZ _0FAA
		MOV 64h, #11h
		MOV A, 78h
		CJNE A, #9h, _0FF1
		LJMP _0FAD
_0FF1		CJNE A, #29h, _0FF7
		LJMP _0FAD
_0FF7		LCALL _10AB
		JB F0, _1003
		LCALL _16E5
		LJMP _1010
_1003		MOV A, 49h
		DEC A
		MOV 49h, A
		JZ _1013
		CJNE A, #4h, _1010
		LJMP _0FC5
_1010		LJMP _0F27
_1013		MOV A, 64h
		CJNE A, #13h, _101B
		LJMP _0FAD
_101B		SETB 6Ah
		LCALL _10C4
		MOV 4Ah, #1h
		LCALL _1117
		LCALL _175F
		MOV R7, #4h
		MOV R1, #33h
		LCALL _0D31
		MOV R0, #OmtiDS_Status
		MOVX A, @R0
		CLR EX0
		MOV A, #OmtiDS_ExtStb1
		MOVX @R0, A
_1038		JB INT0, _1038
		LCALL _157C
		JNB F0, _106D
		MOV A, 78h
		ANL A, #20h
		JZ _1053
		MOV A, 45h
		ANL A, #0F7h
		JNZ _1053
		MOV A, 46h
		ANL A, #7Fh
		JZ _106D
_1053		LJMP _0F6B

_1056:	LCALL	_1755			; *** dead?
	LCALL	_1785			;1059  12 17 85
	JB	F0, _1061		;105C  20 D5 02
	SJMP	_1064			;105F  80 03
_1061:	LJMP	_0FAD			;1061  02 0F AD
_1064:	MOV	A, 5Bh			;1064  E5 5B
	ANL	A, #40h			;1066  54 40
	JNZ	_1061			;1068  70 F7
	LCALL	_177B			;106A  12 17 7B

_106D:	LCALL	_175F			;106D  12 17 5F
	MOV	R7, #4h			;1070  7F 04
	MOV	R1, #33h		;1072  79 33
	LCALL	_0D24			;1074  12 0D 24
	CLR	6Ah			;1077  C2 6A
	JB	6Fh, _1085		;1079  20 6F 09
	MOV	R0, #12h		;107C  78 12
	MOV	A, #8Dh			;107E  74 8D
	MOVX	@R0, A			;1080  F2
	SETB	69h			;1081  D2 69
	INC	7Ah			;1083  05 7A
_1085:	DEC	4Ch			;1085  15 4C
	MOV	A, 4Ch			;1087  E5 4C
	JNZ	_108E			;1089  70 03
	CLR	F0			;108B  C2 D5
	RET				;108D  22
_108E:	MOV	R7, #1h			;108E  7F 01
	LCALL	LBAplusR7
	LCALL	_1156			;1093  12 11 56
	MOV	R0, 7Bh			;1096  A8 7B
	INC	@R0			;1098  06
	MOV	A, @R0			;1099  E6
	MOV	B, A			;109A  F5 F0
	MOV	A, 7Ch			;109C  E5 7C
	CJNE	A, B, _10A4		;109E  B5 F0 03
_10A1:	LJMP	_0F57			;10A1  02 0F 57
_10A4:	JNC	_10A8			;10A4  50 02
	SJMP	_10A1			;10A6  80 F9
_10A8:	LJMP	_1010			;10A8  02 10 10
_10AB:	MOV	A, #3h			;10AB  74 03
	ADD	A, #GeometryStart
	MOV	7Bh, A			;10AF  F5 7B
	MOV	R0, 7Bh			;10B1  A8 7B
	MOV	A, @R0			;10B3  E6
	MOV	B, A			;10B4  F5 F0
	MOV	A, 37h			;10B6  E5 37
	CJNE	A, B, _10BF		;10B8  B5 F0 04
	SETB	F0			;10BB  D2 D5
	SJMP	_10C3			;10BD  80 04
_10BF:	CLR	F0			;10BF  C2 D5
	MOV	37h, @R0		;10C1  86 37
_10C3:	RET				;10C3  22
_10C4:	MOV	R7, #4h			;10C4  7F 04
	MOV	R0, #24h		;10C6  78 24
	MOV	R1, #GeometryStart
_10CA:	MOV	A, @R1			;10CA  E7
	MOVX	@R0, A			;10CB  F2
	INC	R0			;10CC  08
	INC	R1			;10CD  09
	DJNZ	R7, _10CA		;10CE  DF FA
	RET				;10D0  22
_10D1:	MOV	A, 78h			;10D1  E5 78
	JNB	Acc.1, _10DF		;10D3  30 E1 09
_10D6:	MOV	R0, #20h		;10D6  78 20
	MOVX	A, @R0			;10D8  E2
	CLR	EX0			;10D9  C2 A8
	MOV	A, 78h			;10DB  E5 78
	MOVX	@R0, A			;10DD  F2
	RET				;10DE  22
_10DF:	SJMP	_10D6			;10DF  80 F5
_10E1:	MOV	R7, #7h			;10E1  7F 07
	MOV	R0, #22h		;10E3  78 22
	MOV	A, R7			;10E5  EF
	MOVX	@R0, A			;10E6  F2
	RET				;10E7  22
_10E8:	LCALL	_0C37			;10E8  12 0C 37
	XCH	A, B			;10EB  C5 F0
	MOV	A, 28h			;10ED  E5 28
	ANL	A, #0Ch			;10EF  54 0C
	ADD	A, B			;10F1  25 F0
	MOV	DPTR, #_1B6E
	MOVC	A, @A+DPTR		;10F6  93
	MOV	79h, A			;10F7  F5 79
	RET				;10F9  22
_10FA:	LCALL	_1156			;10FA  12 11 56
	MOV	R0, 7Bh			;10FD  A8 7B
	MOV	A, @R0			;10FF  E6
	MOV	7Eh, A			;1100  F5 7E
	MOV	A, 7Ch			;1102  E5 7C
	CLR	C			;1104  C3
	SUBB	A, 7Eh			;1105  95 7E
	MOV	4Ah, A			;1107  F5 4A
	MOV	A, 4Ch			;1109  E5 4C
	CJNE	A, #0h, _1110		;110B  B4 00 02
	SJMP	_1117			;110E  80 07
_1110:	CJNE	A, 4Ah, _111D		;1110  B5 4A 0A
_1113:	MOV	A, 4Ch			;1113  E5 4C
	MOV	4Ah, A			;1115  F5 4A
_1117:	MOV	R0, #21h		;1117  78 21
	MOV	A, 4Ah			;1119  E5 4A
	MOVX	@R0, A			;111B  F2
	RET				;111C  22
_111D:	JNC	_1117			;111D  50 F8
	LJMP	_1113			;111F  02 11 13
_1122:	PUSH	7Eh			;1122  C0 7E
	MOVX	A, @R1			;1124  E3
	MOV	7Eh, A			;1125  F5 7E
	MOVX	A, @R1			;1127  E3
	CJNE	A, 7Eh, _1122		;1128  B5 7E F7
	MOV	7Eh, 4Ah		;112B  85 4A 7E
	MOV	4Ah, A			;112E  F5 4A
	XCH	A, 7Eh			;1130  C5 7E
	CLR	C			;1132  C3
	SUBB	A, 7Eh			;1133  95 7E
	MOV	7Eh, A			;1135  F5 7E
	MOV	A, 48h			;1137  E5 48
	ADD	A, 7Eh			;1139  25 7E
	MOV	48h, A			;113B  F5 48
	MOV	A, 78h			;113D  E5 78
	ANL	A, #2h			;113F  54 02
	JNZ	_114C			;1141  70 09
	MOV	A, 7Eh			;1143  E5 7E
	ADD	A, 7Ah			;1145  25 7A
	MOV	7Ah, A			;1147  F5 7A
	POP	7Eh			;1149  D0 7E
	RET				;114B  22
_114C:	MOV	A, 7Ah			;114C  E5 7A
	CLR	C			;114E  C3
	SUBB	A, 7Eh			;114F  95 7E
	MOV	7Ah, A			;1151  F5 7A
	POP	7Eh			;1153  D0 7E
	RET				;1155  22

_1156		MOV 7Bh, #3h
		MOV A, 7Bh
		ADD A, #GeometryStart
		MOV 7Bh, A			; 7Bh = 71h
		MOV A, #6h
		ADD A, #GeometryStart
		MOV R0, A			; R0 holds 74h
		MOV A, @R0
		MOV 7Fh, A			; 7Fh = 74h
		INC R0
		MOV A, @R0
		INC A
		MOV 7Ch, A			; 7Ch = (75h) +1
		RET

_116D:	MOV	48h, #0h		;116D  75 48 00
	MOV	DPL, #10h		;1170  75 82 10
	MOV	47h, #33h		;1173  75 47 33
	MOV	A, 47h			;1176  E5 47
	MOVX	@DPTR, A		;1178  F0
	JB	6Fh, _118D		;1179  20 6F 11
	MOV	DPL, #12h		;117C  75 82 12
	MOV	47h, #8Dh		;117F  75 47 8D
	SETB	EX1			;1182  D2 AA
	MOV	A, 7Ah			;1184  E5 7A
	JZ	_118D			;1186  60 05
	CJNE	A, 79h, _118B		;1188  B5 79 00
_118B:	JNC	_11BD			;118B  50 30
_118D:	LCALL	_10D1			;118D  12 10 D1
	JB	6Fh, _11A1		;1190  20 6F 0E
	SETB	EX0			;1193  D2 A8
_1195:	MOVX	A, @R1			;1195  E3
	MOV	7Eh, A			;1196  F5 7E
	MOVX	A, @R1			;1198  E3
	CJNE	A, 7Eh, _1195		;1199  B5 7E F9
	CJNE	A, 4Ah, _11A4		;119C  B5 4A 05
	SJMP	_1195			;119F  80 F4
_11A1:	LJMP	_1277			;11A1  02 12 77
_11A4:	CLR	EA			;11A4  C2 AF
	MOV	4Ah, A			;11A6  F5 4A
	INC	48h			;11A8  05 48
	INC	7Ah			;11AA  05 7A
	SETB	EA			;11AC  D2 AF
	MOV	A, 7Ah			;11AE  E5 7A
	CJNE	A, 79h, _11B3		;11B0  B5 79 00
_11B3:	JC	_11D1			;11B3  40 1C
	CLR	EX0			;11B5  C2 A8
	MOV	A, #0h			;11B7  74 00
	MOVX	@R0, A			;11B9  F2
	LCALL	_1117			;11BA  12 11 17
_11BD:	JB	69h, _11C5		;11BD  20 69 05
	MOV	A, 47h			;11C0  E5 47
	MOVX	@DPTR, A		;11C2  F0
	SETB	69h			;11C3  D2 69
_11C5:	MOV	A, 7Ah			;11C5  E5 7A
	CJNE	A, 79h, _11CC		;11C7  B5 79 02
	SJMP	_11C5			;11CA  80 F9
_11CC:	JNC	_11C5			;11CC  50 F7
	LJMP	_118D			;11CE  02 11 8D
_11D1:	JB	69h, _1195		;11D1  20 69 C1
	MOV	A, 47h			;11D4  E5 47
	MOVX	@DPTR, A		;11D6  F0
	SETB	69h			;11D7  D2 69
	LJMP	_1195			;11D9  02 11 95
_11DC:	JNB	F0, _1200		;11DC  30 D5 21
	MOV	A, 78h			;11DF  E5 78
	ANL	A, #20h			;11E1  54 20
	JZ	_11F1			;11E3  60 0C
	MOV	A, 45h			;11E5  E5 45
	ANL	A, #0F7h		;11E7  54 F7
	JNZ	_11F1			;11E9  70 06
	MOV	A, 46h			;11EB  E5 46
	ANL	A, #7Fh			;11ED  54 7F
	JZ	_11FE			;11EF  60 0D
_11F1:	MOV	A, 7Ah			;11F1  E5 7A
	JNZ	_11F1			;11F3  70 FC
	CLR	EX1			;11F5  C2 AA
	MOV	A, 46h			;11F7  E5 46
	JZ	_11FE			;11F9  60 03
	SETB	F0			;11FB  D2 D5
	RET				;11FD  22
_11FE:	CLR	F0			;11FE  C2 D5
_1200:	RET				;1200  22
_1201:	MOV	48h, #0h		;1201  75 48 00
	MOV	DPL, #10h		;1204  75 82 10
	MOV	47h, #31h		;1207  75 47 31
	MOV	A, 47h			;120A  E5 47
	MOVX	@DPTR, A		;120C  F0
	JB	6Fh, _1237		;120D  20 6F 27
	MOV	DPL, #12h		;1210  75 82 12
	MOV	47h, #8Fh		;1213  75 47 8F
	SETB	EX1			;1216  D2 AA
	JB	6Eh, _122C		;1218  20 6E 11
	JB	69h, _1233		;121B  20 69 15
	MOV	A, 52h			;121E  E5 52
	JZ	_1237			;1220  60 15
	MOV	A, 7Ah			;1222  E5 7A
	CJNE	A, 79h, _122A		;1224  B5 79 03
	LJMP	_1237			;1227  02 12 37
_122A:	JC	_1237			;122A  40 0B
_122C:	MOV	A, 47h			;122C  E5 47
	MOVX	@DPTR, A		;122E  F0
	SETB	69h			;122F  D2 69
	CLR	6Eh			;1231  C2 6E
_1233:	MOV	A, 7Ah			;1233  E5 7A
	JZ	_1233			;1235  60 FC
_1237:	LCALL	_1117			;1237  12 11 17
	LCALL	_10D1			;123A  12 10 D1
	JB	6Fh, _1277		;123D  20 6F 37
	SETB	EX0			;1240  D2 A8
_1242:	MOVX	A, @R1			;1242  E3
	MOV	7Eh, A			;1243  F5 7E
	MOVX	A, @R1			;1245  E3
	CJNE	A, 7Eh, _1242		;1246  B5 7E F9
	CJNE	A, 4Ah, _124F		;1249  B5 4A 03
	LJMP	_1242			;124C  02 12 42
_124F:	CLR	EA			;124F  C2 AF
	MOV	4Ah, A			;1251  F5 4A
	INC	48h			;1253  05 48
	DEC	7Ah			;1255  15 7A
	SETB	EA			;1257  D2 AF
	MOV	A, 7Ah			;1259  E5 7A
	JNZ	_1268			;125B  70 0B
	CLR	EX0			;125D  C2 A8
	MOV	A, #0h			;125F  74 00
	MOVX	@R0, A			;1261  F2
	JB	69h, _1233		;1262  20 69 CE
	LJMP	_122C			;1265  02 12 2C
_1268:	JB	69h, _1242		;1268  20 69 D7
	MOV	A, 52h			;126B  E5 52
	JZ	_1242			;126D  60 D3
	MOV	A, 47h			;126F  E5 47
	MOVX	@DPTR, A		;1271  F0
	SETB	69h			;1272  D2 69
	LJMP	_1242			;1274  02 12 42
_1277:	JB	INT0, _1277		;1277  20 B2 FD
	LCALL	_1122			;127A  12 11 22
	LCALL	_1560			;127D  12 15 60
_1280:	JNB	F0, _12A0		;1280  30 D5 1D
	MOV	A, 78h			;1283  E5 78
	ANL	A, #20h			;1285  54 20
	JZ	_1295			;1287  60 0C
	MOV	A, 45h			;1289  E5 45
	ANL	A, #0F7h		;128B  54 F7
	JNZ	_1295			;128D  70 06
	MOV	A, 46h			;128F  E5 46
	ANL	A, #7Fh			;1291  54 7F
	JZ	_129E			;1293  60 09
_1295:	CLR	EX1			;1295  C2 AA
	MOV	A, 46h			;1297  E5 46
	JZ	_129E			;1299  60 03
	SETB	F0			;129B  D2 D5
	RET				;129D  22
_129E:	CLR	F0			;129E  C2 D5
_12A0:	RET				;12A0  22


; ***
; *** increment LBA by R7
; ***
;
LBAplusR7	MOV A, R7
		CLR C
		ADD A, LBA_Lo			; add R7 to LBA
		MOV LBA_Lo, A
		MOV A, LBA_Mi
		ADDC A, #0h
		MOV LBA_Mi, A
		MOV A, LBA_Hi
		ADDC A, #0h
		MOV LBA_Hi, A
		LJMP LBAtoLBA1			; and copy LBA into LBA1. Return from there

; increment LBA by NumberOf_Sec +1
_12B6		CLR F0
		MOV A, #7h
		ADD A, #GeometryStart
		MOV R0, A
		MOV A, @R0			; get NumberOf_Sec
		INC A				; +1
		MOV R7, A			; into R7
		LCALL LBAplusR7
		MOV A, #2h
		ADD A, #GeometryStart
		MOV 7Bh, A			; Current_Hd
		LJMP _12E3

_12CC		MOV R7, #1h
	LCALL	LBAplusR7
	LCALL	_1D08			;12D1  12 1D 08
	MOV	64h, #23h		;12D4  75 64 23
	RET

_12D8:	PUSH	0h			;12D8  C0 00
	MOV	R0, 7Bh			;12DA  A8 7B
	MOV	@R0, #0h		;12DC  76 00
	DEC	R0			;12DE  18
	MOV	7Bh, R0			;12DF  88 7B
	POP	0h			;12E1  D0 00
_12E3:	JNB	6Ch, _130B		;12E3  30 6C 25
	CLR	6Ch			;12E6  C2 6C
	ANL	78h, #0DFh		;12E8  53 78 DF
	MOV	4Eh, 30h		;12EB  85 30 4E
	MOV	4Fh, 31h		;12EE  85 31 4F
	MOV	A, 32h			;12F1  E5 32
	ANL	A, #0Fh			;12F3  54 0F
	MOV	32h, A			;12F5  F5 32
	MOV	R0, 7Bh			;12F7  A8 7B
	MOV	A, 32h			;12F9  E5 32
	MOV	@R0, A			;12FB  F6
	INC	@R0			;12FC  06
	MOV	A, @R0			;12FD  E6
	CJNE	A, 7Fh, _1304		;12FE  B5 7F 03
	LJMP	_134F			;1301  02 13 4F
_1304:	JC	_134F			;1304  40 49
	MOV	@R0, #0h		;1306  76 00
	LJMP	_1337			;1308  02 13 37
_130B:	PUSH	0h			;130B  C0 00
	MOV	R0, 7Bh			;130D  A8 7B
	INC	@R0			;130F  06
	MOV	A, @R0			;1310  E6
	POP	0h			;1311  D0 00
	CJNE	A, 7Fh, _1319		;1313  B5 7F 03
	LJMP	_1354			;1316  02 13 54
_1319:	JC	_1354			;1319  40 39
	PUSH	0h			;131B  C0 00
	MOV	R0, 7Bh			;131D  A8 7B
	MOV	@R0, #0h		;131F  76 00
	POP	0h			;1321  D0 00
	CLR	C			;1323  C3
	MOV	A, 7Bh			;1324  E5 7B
	SUBB	A, #2h			;1326  94 02
	MOV	7Bh, A			;1328  F5 7B
	PUSH	0h			;132A  C0 00
	MOV	R0, 7Bh			;132C  A8 7B
	MOV	A, @R0			;132E  E6
	INC	R0			;132F  08
	MOV	Target_CylH, A			;1330  F5 23
	MOV	A, @R0			;1332  E6
	MOV	Target_CylL, A			;1333  F5 24
	POP	0h			;1335  D0 00
_1337:	CLR	C			;1337  C3
	ADD	A, #1h			;1338  24 01
	MOV	Target_CylL, A			;133A  F5 24
	MOV	A, Target_CylH			;133C  E5 23
	ADDC	A, #0h			;133E  34 00
	MOV	Target_CylH, A			;1340  F5 23
	LCALL	LBAtoLBA1			;1342  12 0C D1
	LCALL	_1E44			;1345  12 1E 44
	JNB	F0, _134F		;1348  30 D5 04
	MOV	64h, #23h		;134B  75 64 23
	RET				;134E  22
_134F:	CLR	EX1			;134F  C2 AA
	LCALL	Do_Seek2			;1351  12 1D 1E
_1354:	LJMP	Select_MFMhd
_1357:	PUSH	0h			;1357  C0 00
	MOV	R0, 7Bh			;1359  A8 7B
	DEC	@R0			;135B  16
	POP	0h			;135C  D0 00
	MOV	A, 56h			;135E  E5 56
	MOV	A, #1h			;1360  74 01
_1362:	MOV	7Eh, A			;1362  F5 7E
	MOV	A, LBA_Lo			;1364  E5 59
	CLR	C			;1366  C3
	SUBB	A, 7Eh			;1367  95 7E
	MOV	LBA_Lo, A			;1369  F5 59
	MOV	A, LBA_Mi			;136B  E5 58
	SUBB	A, #0h			;136D  94 00
	MOV	LBA_Mi, A			;136F  F5 58
	MOV	A, LBA_Hi			;1371  E5 57
	SUBB	A, #0h			;1373  94 00
	MOV	LBA_Hi, A			;1375  F5 57
	LJMP	LBAtoLBA1			;1377  02 0C D1
_137A:	CLR	6Bh			;137A  C2 6B
	MOV	A, #6Eh			;137C  74 6E
	MOV	R1, #21h		;137E  79 21
	MOVX	@R1, A			;1380  F3
	MOV	R0, #20h		;1381  78 20
	MOVX	A, @R0			;1383  E2
	CLR	EX0			;1384  C2 A8
	MOV	A, #0A1h		;1386  74 A1
	MOVX	@R0, A			;1388  F2
_1389:	MOVX	A, @R0			;1389  E2
	MOV	7Eh, A			;138A  F5 7E
	MOVX	A, @R0			;138C  E2
	CJNE	A, 7Eh, _1389		;138D  B5 7E F9
	ANL	A, #30h			;1390  54 30
	JZ	_13A9			;1392  60 15
_1394:	MOV	A, 7Eh			;1394  E5 7E
	ANL	A, #1h			;1396  54 01
	JNZ	_1389			;1398  70 EF
	JB	6Bh, _13A2		;139A  20 6B 05
	MOV	64h, #12h		;139D  75 64 12
	SJMP	_13A5			;13A0  80 03
_13A2:	MOV	64h, #14h		;13A2  75 64 14
_13A5:	SETB	C			;13A5  D3
	SETB	F0			;13A6  D2 D5
	RET				;13A8  22
_13A9:	SETB	6Bh			;13A9  D2 6B
	JNB	6Dh, _13B4		;13AB  30 6D 06
	MOV	A, 7Eh			;13AE  E5 7E
	ANL	A, #70h			;13B0  54 70
	JNZ	_1394			;13B2  70 E0
_13B4:	MOV	R1, #24h		;13B4  79 24
	MOVX	A, @R1			;13B6  E3
	INC	R1			;13B7  09
	MOV	7Eh, A			;13B8  F5 7E
	MOVX	A, @R1			;13BA  E3
	MOV	B, A			;13BB  F5 F0
	MOV	R0, #20h		;13BD  78 20
	MOV	A, #0h			;13BF  74 00
	MOVX	@R0, A			;13C1  F2
	MOVX	A, @R0			;13C2  E2
_13C3:	MOV	R0, #26h		;13C3  78 26
	MOVX	A, @R0			;13C5  E2
	MOV	R5, A			;13C6  FD
	CLR	F0			;13C7  C2 D5
	CLR	C			;13C9  C3
	RET				;13CA  22
_13CB:	LJMP	_14DD			;13CB  02 14 DD

Int_EXT1	JNB PBusy, _13CB
	PUSH	PSW			;13D1  C0 D0
	PUSH	Acc			;13D3  C0 E0
	JNB	79h, _13ED		;13D5  30 79 15
	MOV	55h, DPH		;13D8  85 83 55
	MOV	50h, DPL		;13DB  85 82 50
	MOV	DPTR, #0E0h		;13DE  90 00 E0
	MOVX	A, @DPTR		;13E1  E0
	JB	Acc.7, _141D		;13E2  20 E7 38
	JB	Acc.0, _1453		;13E5  20 E0 6B
	JB	Acc.4, _141A		;13E8  20 E4 2F
	SJMP	_1451			;13EB  80 64
_13ED:	MOV	DPTR, #0E0h		;13ED  90 00 E0
	MOVX	A, @DPTR		;13F0  E0
	JB	Acc.7, _141D		;13F1  20 E7 29
	CLR	35h			;13F4  C2 35
	LCALL	_0BE5			;13F6  12 0B E5
	MOV	A, 3Dh			;13F9  E5 3D
	JZ	_140A			;13FB  60 0D
	CJNE	A, #1h, _1405		;13FD  B4 01 05
	MOV	DPTR, #47Fh		;1400  90 04 7F
	SJMP	_140D			;1403  80 08
_1405:	MOV	DPTR, #4ADh		;1405  90 04 AD
	SJMP	_140D			;1408  80 03
_140A:	MOV	DPTR, #298h		;140A  90 02 98
_140D:	POP	Acc			;140D  D0 E0
	POP	PSW			;140F  D0 D0
	POP	B			;1411  D0 F0
	POP	B			;1413  D0 F0
	PUSH	DPL			;1415  C0 82
	PUSH	DPH			;1417  C0 83
	RETI				;1419  32
;
_141A:	LJMP	_14D1			;141A  02 14 D1
_141D:	MOV	DPTR, #0E0h		;141D  90 00 E0
	MOVX	A, @DPTR		;1420  E0
	MOV	DPTR, #0E2h		;1421  90 00 E2
	MOVX	A, @DPTR		;1424  E0
	JB	Acc.5, _1451		;1425  20 E5 29
_1428:	MOVX	A, @DPTR		;1428  E0
	JB	Acc.4, _1428		;1429  20 E4 FC
	JB	79h, _143B		;142C  20 79 0C
	MOV	DPTR, #0E2h		;142F  90 00 E2
	MOV	A, #81h			;1432  74 81
	MOVX	@DPTR, A		;1434  F0
	MOV	DPTR, #0E1h		;1435  90 00 E1
	MOV	A, #83h			;1438  74 83
	MOVX	@DPTR, A		;143A  F0
_143B:	POP	Acc			;143B  D0 E0
	POP	PSW			;143D  D0 D0
	POP	DPH			;143F  D0 83
	POP	DPH			;1441  D0 83
	MOV	DPTR, #1A2h		;1443  90 01 A2
	PUSH	DPL			;1446  C0 82
	PUSH	DPH			;1448  C0 83
	MOV	DPH, 55h		;144A  85 55 83
	MOV	DPL, 50h		;144D  85 50 82
	RETI				;1450  32
_1451:	SJMP	_14C6			;1451  80 73
_1453:	CLR	30h			;1453  C2 30
	MOV	A, 26h			;1455  E5 26
	MOV	DPTR, #0E0h		;1457  90 00 E0
	MOVX	@DPTR, A		;145A  F0
	MOV	R0, #0E1h		;145B  78 E1
	MOV	A, #83h			;145D  74 83
	MOVX	@R0, A			;145F  F2
_1460:	MOVX	A, @R0			;1460  E2
	ANL	A, #4h			;1461  54 04
	JNZ	_1460			;1463  70 FB
	MOV	R7, #5h			;1465  7F 05
	MOV	R1, #56h		;1467  79 56
	MOV	A, #85h			;1469  74 85
	MOVX	@R0, A			;146B  F2
	MOV	R0, #0E2h		;146C  78 E2
	MOV	A, #84h			;146E  74 84
	MOVX	@R0, A			;1470  F2
	SETB	34h			;1471  D2 34
	LCALL	_0BE5			;1473  12 0B E5
	MOV	R0, #0E7h		;1476  78 E7
	MOVX	A, @R0			;1478  E2
_1479:	JB	INT1, _1479		;1479  20 B3 FD
	MOVX	A, @R0			;147C  E2
	MOV	@R1, A			;147D  F7
	INC	R1			;147E  09
	DJNZ	R7, _1479		;147F  DF F8
	MOV	A, R1			;1481  E9
	CJNE	A, #5Fh, _1487		;1482  B4 5F 02
	SJMP	_149F			;1485  80 18
_1487:	MOV	A, 56h			;1487  E5 56
	CJNE	A, #25h, _148E		;1489  B4 25 02
	SJMP	_149B			;148C  80 0D
_148E:	CJNE	A, #28h, _1493		;148E  B4 28 02
	SJMP	_149B			;1491  80 08
_1493:	CJNE	A, #2Ah, _1498		;1493  B4 2A 02
	SJMP	_149B			;1496  80 03
_1498:	CJNE	A, #2Fh, _149F		;1498  B4 2F 04
_149B:	MOV	R7, #4h			;149B  7F 04
	SJMP	_1479			;149D  80 DA
_149F:	MOV	R0, #0E6h		;149F  78 E6
_14A1:	JB	INT1, _14A1		;14A1  20 B3 FD
	MOVX	A, @R0			;14A4  E2
	MOV	@R1, A			;14A5  F7
	MOV	R0, #0E1h		;14A6  78 E1
	MOV	A, #5h			;14A8  74 05
	MOVX	@R0, A			;14AA  F2
	MOV	R0, #0E2h		;14AB  78 E2
	MOV	A, #82h			;14AD  74 82
	MOVX	@R0, A			;14AF  F2
	POP	Acc			;14B0  D0 E0
	POP	PSW			;14B2  D0 D0
	POP	DPH			;14B4  D0 83
	POP	DPH			;14B6  D0 83
	MOV	DPTR, #1F6h		;14B8  90 01 F6
	PUSH	DPL			;14BB  C0 82
	PUSH	DPH			;14BD  C0 83
	MOV	DPH, 55h		;14BF  85 55 83
	MOV	DPL, 50h		;14C2  85 50 82
	RETI				;14C5  32
_14C6:	POP	Acc			;14C6  D0 E0
	POP	PSW			;14C8  D0 D0
	MOV	DPH, 55h		;14CA  85 55 83
	MOV	DPL, 50h		;14CD  85 50 82
	RETI				;14D0  32
_14D1:	SETB	76h			;14D1  D2 76
	CLR	34h			;14D3  C2 34
	MOV	A, 26h			;14D5  E5 26
	MOV	DPTR, #0E0h		;14D7  90 00 E0
	MOVX	@DPTR, A		;14DA  F0
	SJMP	_14C6			;14DB  80 E9
_14DD:	PUSH	Acc			;14DD  C0 E0
	PUSH	PSW			;14DF  C0 D0
	PUSH	DPH			;14E1  C0 83
	PUSH	DPL			;14E3  C0 82
	MOV	DPH, #0h		;14E5  75 83 00
	MOV	DPL, #12h		;14E8  75 82 12
	MOV	A, 78h			;14EB  E5 78
	ANL	A, #2h			;14ED  54 02
	JNZ	_1505			;14EF  70 14
	MOV	A, 7Ah			;14F1  E5 7A
	DEC	7Ah			;14F3  15 7A
	MOV	A, 7Ah			;14F5  E5 7A
	JZ	_1522			;14F7  60 29
	MOV	A, 47h			;14F9  E5 47
	MOVX	@DPTR, A		;14FB  F0
	POP	DPL			;14FC  D0 82
	POP	DPH			;14FE  D0 83
	POP	PSW			;1500  D0 D0
	POP	Acc			;1502  D0 E0
	RETI				;1504  32
_1505:	INC	7Ah			;1505  05 7A
	DEC	52h			;1507  15 52
	MOV	A, 52h			;1509  E5 52
	JZ	_1522			;150B  60 15
	MOV	A, 7Ah			;150D  E5 7A
	CJNE	A, 79h, _1514		;150F  B5 79 02
	SJMP	_1522			;1512  80 0E
_1514:	JNC	_1522			;1514  50 0C
	MOV	A, 47h			;1516  E5 47
	MOVX	@DPTR, A		;1518  F0
	POP	DPL			;1519  D0 82
	POP	DPH			;151B  D0 83
	POP	PSW			;151D  D0 D0
	POP	Acc			;151F  D0 E0
	RETI				;1521  32
_1522:	CLR	69h			;1522  C2 69
	MOV	A, 47h			;1524  E5 47
	ANL	A, #0F6h		;1526  54 F6
	MOVX	@DPTR, A		;1528  F0
	POP	DPL			;1529  D0 82
	POP	DPH			;152B  D0 83
	POP	PSW			;152D  D0 D0
	POP	Acc			;152F  D0 E0
	RETI				;1531  32


Int_EXT0	POP Acc
		POP Acc
	LCALL	_1122			;1536  12 11 22
	MOV	A, 78h			;1539  E5 78
	ANL	A, #2h			;153B  54 02
	JNZ	_1551			;153D  70 12
	MOV	A, 7Ah			;153F  E5 7A
	JZ	_1551			;1541  60 0E
	JB	69h, _1551		;1543  20 69 0B
	MOV	A, 47h			;1546  E5 47
	MOV	DPH, #0h		;1548  75 83 00
	MOV	DPL, #12h		;154B  75 82 12
	MOVX	@DPTR, A		;154E  F0
	SETB	69h			;154F  D2 69
_1551:	LCALL	_1560			;1551  12 15 60
	MOV	A, 78h			;1554  E5 78
	ANL	A, #1h			;1556  54 01
	JNZ	_155D			;1558  70 03
	LJMP	_1280			;155A  02 12 80
_155D:	LJMP	_11DC			;155D  02 11 DC
_1560:	PUSH	1h			;1560  C0 01
	MOV	R1, 7Bh			;1562  A9 7B
	MOV	A, @R1			;1564  E7
	ADD	A, 48h			;1565  25 48
	MOV	@R1, A			;1567  F7
	POP	1h			;1568  D0 01
	MOV	A, 48h			;156A  E5 48
	ADD	A, LBA_Lo			;156C  25 59
	MOV	LBA_Lo, A			;156E  F5 59
	MOV	A, LBA_Mi			;1570  E5 58
	ADDC	A, #0h			;1572  34 00
	MOV	LBA_Mi, A			;1574  F5 58
	MOV	A, LBA_Hi			;1576  E5 57
	ADDC	A, #0h			;1578  34 00
	MOV	LBA_Hi, A			;157A  F5 57
_157C:	MOV	R0, #20h		;157C  78 20
	MOVX	A, @R0			;157E  E2
	INC	R0			;157F  08
	MOV	46h, A			;1580  F5 46
	MOVX	A, @R0			;1582  E2
	ANL	A, #1Fh			;1583  54 1F
	CLR	EX0			;1585  C2 A8
	MOV	45h, A			;1587  F5 45
	MOV	A, 46h			;1589  E5 46
	JNZ	_1590			;158B  70 03
	CLR	F0			;158D  C2 D5
	RETI				;158F  32
_1590:	SETB	F0			;1590  D2 D5
	RETI

Int_T0		RETI

Int_T1		PUSH 0h
	PUSH	Acc			;1596  C0 E0
	MOV	A, 50h			;1598  E5 50
	DEC	A			;159A  14
	MOV	50h, A			;159B  F5 50
	JZ	_15A4			;159D  60 05
_159F:	POP	Acc			;159F  D0 E0
	POP	0h			;15A1  D0 00
	RETI				;15A3  32
_15A4:	CLR	TR1			;15A4  C2 8E
	CLR	ET1			;15A6  C2 AB
	MOV	A, #GeometryStart
	ADD	A, #4h			;15AA  24 04
	MOV	R0, A			;15AC  F8
	MOV	A, @R0			;15AD  E6
	MOV	Target_CylH, A
	MOV	A, #GeometryStart
	ADD	A, #5h			;15B2  24 05
	MOV	R0, A			;15B4  F8
	MOV	A, @R0			;15B5  E6
	MOV	Target_CylL, A
		LCALL Do_Seek
	SETB	TR1			;15BB  D2 8E
	SJMP	_159F			;15BD  80 E0
_15BF:	MOV	R1, #30h		;15BF  79 30
	LCALL	_1692			;15C1  12 16 92
	LCALL	_0D31			;15C4  12 0D 31
	LCALL	_09F2			;15C7  12 09 F2
	MOV	R0, #10h		;15CA  78 10
	MOV	A, #33h			;15CC  74 33
	MOVX	@R0, A			;15CE  F2
	MOV	A, #0h			;15CF  74 00
_15D1:	MOV	R0, #27h		;15D1  78 27
	MOVX	@R0, A			;15D3  F2
	MOV	R0, #21h		;15D4  78 21
	MOV	A, #1h			;15D6  74 01
	MOVX	@R0, A			;15D8  F2
	LCALL	_169C			;15D9  12 16 9C
	MOV	R0, #20h		;15DC  78 20
	MOVX	A, @R0			;15DE  E2
	CLR	EX0			;15DF  C2 A8
	MOV	A, #21h			;15E1  74 21
	MOVX	@R0, A			;15E3  F2
_15E4:	JB	INT0, _15E4		;15E4  20 B2 FD
	LCALL	_157C			;15E7  12 15 7C
	JNB	F0, _161E		;15EA  30 D5 31
	MOV	A, 46h			;15ED  E5 46
	CJNE	A, #80h, _15FA		;15EF  B4 80 08
	MOV	A, 45h			;15F2  E5 45
	CJNE	A, #8h, _15FA		;15F4  B4 08 03
	LJMP	_161E			;15F7  02 16 1E
_15FA:	MOV	A, 48h			;15FA  E5 48
	INC	A			;15FC  04
	MOV	48h, A			;15FD  F5 48
	MOV	B, 7Ch			;15FF  85 7C F0
	CJNE	A, B, _1607		;1602  B5 F0 02
	SJMP	_1609			;1605  80 02
_1607:	JNC	_15D1			;1607  50 C8
_1609:	MOV	R1, #30h		;1609  79 30
	LCALL	_1692			;160B  12 16 92
	LCALL	_0D24			;160E  12 0D 24
	MOV	A, 67h			;1611  E5 67
	MOV	R5, #4h			;1613  7D 04
	LCALL	_09F6			;1615  12 09 F6
	MOV	64h, #3Ch		;1618  75 64 3C
	LJMP	_16F2			;161B  02 16 F2
_161E:	MOV	A, 67h			;161E  E5 67
	MOV	R5, #4h			;1620  7D 04
	LCALL	_09F6			;1622  12 09 F6
	MOV	R1, #3Eh		;1625  79 3E
	LCALL	_1692			;1627  12 16 92
	LCALL	_0D31			;162A  12 0D 31
	MOV	R1, #30h		;162D  79 30
	LCALL	_1692			;162F  12 16 92
	LCALL	_0D24			;1632  12 0D 24
	MOV	R1, #GeometryStart
	MOV	A, @R1			;1637  E7
	MOV	30h, A			;1638  F5 30
	INC	R1			;163A  09
	MOV	A, @R1			;163B  E7
	MOV	31h, A			;163C  F5 31
	INC	R1			;163E  09
	MOV	A, @R1			;163F  E7
	MOV	32h, A			;1640  F5 32
	PUSH	Acc			;1642  C0 E0
	MOV	A, LBA_Hi
	ANL	A, #60h			;1646  54 60
	MOV	32h, A			;1648  F5 32
	POP	Acc			;164A  D0 E0
	ORL	A, 32h			;164C  45 32
	MOV	32h, A			;164E  F5 32
	MOV	A, tmp_Cyl2
	MOV	@R1, A			;1652  F7
	MOV	Target_CylH, tmp_Cyl4
	MOV	Target_CylL, tmp_Cyl3
_1659:	LCALL	Do_Seek1			;1659  12 1D 11
	LCALL	Select_MFMhd
	SETB	6Ch			;165F  D2 6C
	LCALL	_16A5			;1661  12 16 A5
	LCALL	_16B1			;1664  12 16 B1
	JB	F0, _167B		;1667  20 D5 11
	MOV	A, 78h			;166A  E5 78
	ORL	A, #20h			;166C  44 20
	MOV	78h, A			;166E  F5 78
	SETB	4Ch			;1670  D2 4C
	MOV	A, 56h			;1672  E5 56
	CJNE	A, #5h, _1678		;1674  B4 05 01
	RET				;1677  22
_1678:	LJMP	_0F27			;1678  02 0F 27
_167B:	JC	_16F2			;167B  40 75
	MOV	A, 5Bh			;167D  E5 5B
	ANL	A, #80h			;167F  54 80
	JNZ	_16F2			;1681  70 6F
	DEC	7Dh			;1683  15 7D
	MOV	A, 7Dh			;1685  E5 7D
	JZ	_16F2			;1687  60 69
	CJNE	A, #4h, _1659		;1689  B4 04 CD
	LCALL	_1DA6			;168C  12 1D A6
	LJMP	_1659			;168F  02 16 59
_1692		MOV R2, #0h
		MOV R3, #0h
		LCALL Omti_DMAdrSet2	; set DMA Ch 2 address to 0000h
		MOV R7, #3h
		RET
_169C		MOV R2, #0h
		MOV R3, #0h
_16A0		MOV R0, #0h
		LJMP Omti_DMAdrSet2
_16A5		JB 6Fh, _1704
		MOV A, 78h
		ANL A, #2h
		JNZ _1704
		LJMP Omti_DMAdrSet2
_16B1:	CLR	6Dh			;16B1  C2 6D
	LCALL	_137A			;16B3  12 13 7A
	JC	_16E1			;16B6  40 29
	MOV	7Bh, #GeometryStart
	MOV	R0, 7Bh			;16BB  A8 7B
	MOV	A, @R0			;16BD  E6
	CJNE	A, 7Eh, _16D8		;16BE  B5 7E 17
	INC	7Bh			;16C1  05 7B
	MOV	R0, 7Bh			;16C3  A8 7B
	MOV	A, @R0			;16C5  E6
	CJNE	A, B, _16DA		;16C6  B5 F0 11
	MOV	A, R5			;16C9  ED
	ANL	A, #0Fh			;16CA  54 0F
	MOV	R5, A			;16CC  FD
	INC	7Bh			;16CD  05 7B
	MOV	R0, 7Bh			;16CF  A8 7B
	MOV	A, @R0			;16D1  E6
	CJNE	A, 5h, _16D8		;16D2  B5 05 03
	CLR	F0			;16D5  C2 D5
	RET				;16D7  22
_16D8:	INC	7Bh			;16D8  05 7B
_16DA:	CLR	4Ch			;16DA  C2 4C
	MOV	64h, #15h		;16DC  75 64 15
	SETB	F0			;16DF  D2 D5
_16E1:	RET				;16E1  22
_16E2:	MOV	37h, #0FFh		;16E2  75 37 FF
_16E5:	MOV	49h, #8h		;16E5  75 49 08
	MOV	7Dh, #8h		;16E8  75 7D 08
	RET				;16EB  22

_16EC		MOV 64h, #3h
		LJMP _16F2

_16F2		JB 6Fh, _1703
		MOV A, 56h
		CJNE A, #0Ah, _1700
		JNB 69h, _1700
		JB PCmd, $		; wait for PCmd
_1700		LJMP _01FC
_1703		RET

_1704:	CLR	C			;1704  C3
	MOV	A, 4Bh			;1705  E5 4B
	SUBB	A, 4Ch			;1707  95 4C
	MOV	R7, A			;1709  FF
	JZ	_169C			;170A  60 90
	LCALL	_082E			;170C  12 08 2E
	CLR	C			;170F  C3
	MOV	A, R3			;1710  EB
	ADD	A, #1h			;1711  24 01
	MOV	R3, A			;1713  FB
	MOV	A, R2			;1714  EA
	ADDC	A, #0h			;1715  34 00
	MOV	R2, A			;1717  FA
	MOV	A, R7			;1718  EF
	DEC	A			;1719  14
	MOV	R7, A			;171A  FF
	JZ	_16A0			;171B  60 83
	MOV	A, R2			;171D  EA
	MOV	R4, A			;171E  FC
	MOV	A, R3			;171F  EB
	MOV	R5, A			;1720  FD
_1721:	CLR	C			;1721  C3
	MOV	A, R3			;1722  EB
	ADD	A, R5			;1723  2D
	MOV	R3, A			;1724  FB
	MOV	A, R2			;1725  EA
	ADDC	A, R4			;1726  3C
	MOV	R2, A			;1727  FA
	DJNZ	R7, _1721		;1728  DF F7
	LJMP	_16A0			;172A  02 16 A0
_172D:	LCALL	_13C3			;172D  12 13 C3
_1730:	MOV	A, R5			;1730  ED
	ANL	A, #0E0h		;1731  54 E0
	JZ	_174D			;1733  60 18
	CJNE	A, #80h, _173D		;1735  B4 80 05
	MOV	64h, #99h		;1738  75 64 99
	SJMP	_1746			;173B  80 09
_173D:	CJNE	A, #20h, _1751		;173D  B4 20 11
	MOV	64h, #3Fh		;1740  75 64 3F
	JB	6Ch, _174A		;1743  20 6C 04
_1746:	CLR	F0			;1746  C2 D5
	SETB	C			;1748  D3
	RET				;1749  22
_174A:	MOV	64h, #0h		;174A  75 64 00
_174D:	SETB	F0			;174D  D2 D5
	CLR	C			;174F  C3
	RET				;1750  22
_1751:	CLR	C			;1751  C3
	CLR	F0			;1752  C2 D5
	RET				;1754  22

_1755:	LCALL	_1775			; *** dead?
		LCALL MFM_ReadSctr
	LCALL	_082E			;175B  12 08 2E
	RET				;175E  22

_175F:	JNB	6Fh, _176C		;175F  30 6F 0A
	DEC	4Ch			;1762  15 4C
	LCALL	_1704			;1764  12 17 04
	INC	4Ch			;1767  05 4C
	LJMP	_1772			;1769  02 17 72
_176C:	LCALL	_082E			;176C  12 08 2E
	LCALL	Omti_DMAdrSet1
_1772:	LJMP	Omti_DMAdr3Set

_1775:	LCALL	_082E			; *** dead?
	LJMP	_1772			;1778  02 17 72

_177B		JNB 6Fh, _177E
_177E		LCALL _1782
		RET
_1782		LJMP Omti_DMAdr3Set

_1785		SETB F0
		RET

_1788:	MOV	64h, #11h		; *** dead?
	SETB	F0			;178B  D2 D5
	RET				;178D  22

_178E:	CLR	F0			; *** dead?
	MOV	A, #55h			;1790  74 55
	LCALL	_17B5			;1792  12 17 B5
	JB	F0, _17B4		;1795  20 D5 1C
	MOV	A, #0AAh		;1798  74 AA
	LCALL	_17B5			;179A  12 17 B5
	JB	F0, _17B4		;179D  20 D5 14
	MOV	A, #99h			;17A0  74 99
	LCALL	_17B5			;17A2  12 17 B5
	JB	F0, _17B4		;17A5  20 D5 0C
	MOV	A, #0F0h		;17A8  74 F0
	LCALL	_17B5			;17AA  12 17 B5
	JB	F0, _17B4		;17AD  20 D5 04
	CLR	A			;17B0  E4
	LCALL	_17B5			;17B1  12 17 B5
_17B4:	RET				;17B4  22
_17B5:	MOV	B, A			;17B5  F5 F0
	MOV	R7, #0h			;17B7  7F 00
	NOP				;17B9  00
	NOP				;17BA  00
	NOP				;17BB  00
_17BC:	MOVX	@DPTR, A		;17BC  F0
	INC	DPTR			;17BD  A3
	DJNZ	R7, _17BC		;17BE  DF FC
	NOP				;17C0  00
	NOP				;17C1  00
	NOP				;17C2  00
	MOV	R7, #0h			;17C3  7F 00
_17C5:	MOVX	A, @DPTR		;17C5  E0
	CJNE	A, B, _17CD		;17C6  B5 F0 04
	INC	DPTR			;17C9  A3
	DJNZ	R7, _17C5		;17CA  DF F9
	RET				;17CC  22
_17CD:	SETB	F0			;17CD  D2 D5
	RET				;17CF  22

_17D0		CLR 42h
		CLR 43h
		MOV R4, #55h
		LCALL _188C
	LCALL	_1897			;17D9  12 18 97
	JB	F0, _1816		;17DC  20 D5 37
	MOV	R4, #0AAh		;17DF  7C AA
	LCALL	_188C			;17E1  12 18 8C
	MOV	R4, #55h		;17E4  7C 55
	LCALL	_18DD			;17E6  12 18 DD
	MOV	R4, #0AAh		;17E9  7C AA
	LCALL	_1897			;17EB  12 18 97
	JB	F0, _1819		;17EE  20 D5 28
	MOV	R4, #55h		;17F1  7C 55
	LCALL	_18CE			;17F3  12 18 CE
	JB	F0, _1819		;17F6  20 D5 20
	MOV	R4, #0AAh		;17F9  7C AA
	LCALL	_18A2			;17FB  12 18 A2
	MOV	R4, #99h		;17FE  7C 99
	LCALL	_18FB			;1800  12 18 FB
	MOV	R4, #0AAh		;1803  7C AA
	LCALL	_18AD			;1805  12 18 AD
	JB	F0, _183D		;1808  20 D5 32
	MOV	R4, #99h		;180B  7C 99
	LCALL	_18EC			;180D  12 18 EC
	JB	F0, _183D		;1810  20 D5 2A
	LJMP	_1866			;1813  02 18 66
_1816:	LJMP	_1863			;1816  02 18 63
_1819:	MOV	R4, #0AAh		;1819  7C AA
	LCALL	_188C			;181B  12 18 8C
	LCALL	_1897			;181E  12 18 97
	JB	F0, _1816		;1821  20 D5 F2
	MOV	R4, #99h		;1824  7C 99
	LCALL	_188C			;1826  12 18 8C
	LCALL	_1897			;1829  12 18 97
	JB	F0, _1816		;182C  20 D5 E7
	MOV	R4, #0F0h		;182F  7C F0
	LCALL	_188C			;1831  12 18 8C
	LCALL	_1897			;1834  12 18 97
	JB	F0, _1816		;1837  20 D5 DC
	LJMP	_1865			;183A  02 18 65
_183D:	MOV	R4, #0AAh		;183D  7C AA
	LCALL	_18A2			;183F  12 18 A2
	LCALL	_18AD			;1842  12 18 AD
	JB	F0, _1863		;1845  20 D5 1B
	MOV	R4, #99h		;1848  7C 99
	LCALL	_18A2			;184A  12 18 A2
	LCALL	_18AD			;184D  12 18 AD
	JB	F0, _1863		;1850  20 D5 10
	MOV	R4, #0F0h		;1853  7C F0
	LCALL	_18A2			;1855  12 18 A2
	LCALL	_18AD			;1858  12 18 AD
	JB	F0, _1863		;185B  20 D5 05
	SETB	42h			;185E  D2 42
	LJMP	_1865			;1860  02 18 65
_1863:	SETB	F0			;1863  D2 D5
_1865:	RET				;1865  22
_1866:	MOV	R4, #0AAh		;1866  7C AA
	LCALL	_18B8			;1868  12 18 B8
	LCALL	_18C3			;186B  12 18 C3
	JB	F0, _1863		;186E  20 D5 F2
	MOV	R4, #99h		;1871  7C 99
	LCALL	_18B8			;1873  12 18 B8
	LCALL	_18C3			;1876  12 18 C3
	JB	F0, _1863		;1879  20 D5 E7
	MOV	R4, #0F0h		;187C  7C F0
	LCALL	_18B8			;187E  12 18 B8
	LCALL	_18C3			;1881  12 18 C3
	JB	F0, _1863		;1884  20 D5 DC
	SETB	43h			;1887  D2 43
	LJMP	_1865			;1889  02 18 65


_188C		LCALL Omti_DMAdrSet2
		MOV R6, #0FFh
		MOV R7, #7h
		LCALL _190A		; write R4 7FFh times into DMA Ch 3 (or copy from Ch2 to Ch3 ??)
		RET
_1897		LCALL Omti_DMAdrSet2
		MOV R6, #0FFh
		MOV R7, #7h
		LCALL _1919		; read up to 7FFh bytes from DMA Ch 3 and come back when data <> R4
		RET
_18A2		LCALL Omti_DMAdrSet2
		MOV R6, #0FFh
		MOV R7, #1Fh
		LCALL _190A		; write R4 1FFh times into DMA Ch 3 (or copy from Ch2 to Ch3 ??)
		RET
_18AD		LCALL Omti_DMAdrSet2
		MOV R6, #0FFh
		MOV R7, #1Fh
		LCALL _1919		; read up to 1FFh bytes from DMA Ch 3 and come back when data <> R4
		RET
_18B8		LCALL Omti_DMAdrSet2
		MOV R6, #0FEh
		MOV R7, #7Fh
		LCALL _190A		; write R4 7FFEh times into DMA Ch 3 (or copy from Ch2 to Ch3 ??)
		RET
_18C3		LCALL Omti_DMAdrSet2
		MOV R6, #0FEh
		MOV R7, #7Fh
		LCALL _1919		; read up to 7FFEh bytes from DMA Ch 3 and come back when data <> R4
		RET

_18CE		MOV R2, #0h
		MOV R3, #8h
		LCALL Omti_DMAdrSet	; set DMA address to 0800h
		MOV R6, #0h
		MOV R7, #18h
		LCALL _1919		; read up to 1800h bytes from DMA Ch 3 and come back when data <> R4
		RET
_18DD		MOV R2, #0h
		MOV R3, #8h
		LCALL Omti_DMAdrSet	; set DMA address to 0800h
		MOV R6, #0h
		MOV R7, #18h
		LCALL _190A		; write R4 1800h times into DMA Ch 3 (or copy from Ch2 to Ch3 ??)
		RET
_18EC		MOV R2, #0h
		MOV R3, #20h
		LCALL Omti_DMAdrSet	; set DMA address to 2000h
		MOV R6, #0FFh
		MOV R7, #5Fh
		LCALL _1919		; read up to 5FFFh bytes from DMA Ch 3 and come back when data <> R4
		RET
_18FB		MOV R2, #0h
		MOV R3, #20h
		LCALL Omti_DMAdrSet	; set DMA address to 2000h
		MOV R6, #0FFh
		MOV R7, #5Fh
		LCALL _190A		; write R4 5FFFh times into DMA Ch 3 (or copy from Ch2 to Ch3 ??)
		RET

; ***
; *** write R4 R7.R6 times into DMA channel 3
; ***
;
_190A		MOV DPTR, #OmtiMC_Ch3Ctrl
		MOV A, #33h			; configure for write
		MOVX @DPTR, A
		MOV R0, #OmtiDS_MCtoMem
		MOV A, R4
_1913		MOVX @R0, A			; write R4 to DMA buffer
		DJNZ R6, _1913			; next byte
		DJNZ R7, _1913
		RET

; ***
; *** read (R7.R6) bytes from DMA channel 3 and compare with R4
; *** F0 set when error
; ***
;
_1919 		MOV R0, #OmtiMC_Ch3Ctrl
		MOV A, #31h			; configure for read
		MOVX @R0, A
		MOV R0, #OmtiDS_MemToMC
		MOVX A, @R0			; read dummy byte from buffer
		MOV B, R4
_1923		MOVX A, @R0			; read byte from buffer
		CJNE A, B, _192E		; compare with R4 and exit if mismatch
		DJNZ R6, _1923			; next byte
		DJNZ R7, _1923
		CLR F0				; done, F0 cleared
		RET
_192E		SETB F0				; compare failed, F0 set
		RET


; ***
; *** Test and Setup Omti Disk Sequencer
; ***
;
; test Omti Sequencer state machine registers
OmtiInit_3	CLR ErrorFlag
		CLR F0				; no error
		MOV P2, #Omti_base
		MOV R7, #16			; test 16 state register pairs
		MOV R0, #0			;  and start at 0
OmtiInit_31	MOV R1, #OmtiDS_SeqStart
		MOV A, R0
		MOVX @R1, A			; select state via sequencer state counter
		MOV R1, #OmtiDS_SeqCnt
		MOV A, #55h
		LCALL OmtiInit_RWtest		; perform 55/AA write test with sequencer counter register
		JB F0, OmtiInit_3fail
		INC R1
		LCALL OmtiInit_RWtest		; perform 55/AA write test with sequencer value register
		JB F0, OmtiInit_3fail
		INC R0				;  next pair
		DJNZ R7, OmtiInit_31
		LJMP OmtiInit_32
OmtiInit_3fail	RET
; initialize Sequencer command/control registers
OmtiInit_32	MOV DPTR, #OmtiDS_Command
		MOV R7, #24
		MOV B, #0
OmtiInit_33	PUSH DPL
		PUSH DPH
		MOV DPTR, #OmtiInit_Table2
		MOV A, B
		MOVC A, @A+DPTR			; get value from 1B24..1B3B
		POP DPH
		POP DPL
		MOVX @DPTR, A			; and write it into Omti Registers 20..37h
		INC DPTR
		MOV A, B
		INC A
		MOV B, A
		DJNZ R7, OmtiInit_33
; initialize Sequencer state machine registers
		MOV R7, #16
		MOV B, #0
		MOV R6, #0
OmtiInit_34	MOV DPTR, #OmtiDS_SeqStart	; select state via sequencer state counter
		MOV A, R6
		MOVX @DPTR, A
		MOV A, B
		MOV DPTR, #OmtiInit_Table3
		MOVC A, @A+DPTR			; get value from 1B3C..1B5B
		MOV DPTR, #OmtiDS_SeqCnt
		MOVX @DPTR, A			; and write it into Sequencer Count Register
		MOV A, B
		INC A
		MOV B, A
		MOV DPTR, #OmtiInit_Table3
		MOVC A, @A+DPTR			; get next value
		MOV DPTR, #OmtiDS_SeqVal
		MOVX @DPTR, A			; for register Sequencer Value Register
		MOV A, B
		INC A
		MOV B, A
		INC R6
		DJNZ R7, OmtiInit_34
;
		MOV DPTR, #OmtiDS_Status
		MOVX A, @DPTR			; read Omti Status Register
		INC DPTR
		MOVX A, @DPTR			; read Extended Status Register
		MOV DPTR, #OmtiDS_SeqStart
		MOV A, #33h
		MOVX @DPTR, A			; start and restart from state #3
		CLR F0				; no error
		RET
;
; perform write/readback test with register (P2.R1). F0 set when error.
;
OmtiInit_RWtest	MOV R6, #2h
OmtiInit_RWtst1	MOV B, A
		MOVX @R1, A			; write 055h
		CLR A
		MOVX A, @R1			; read back
		CJNE A, B, OmtiInit_RWtst2
		CPL A				; change into 0AAh
		DJNZ R6, OmtiInit_RWtst1
		RET
OmtiInit_RWtst2	SETB F0				; set F0 when mismatch
		SETB ErrorFlag
		RET



_19C4:	CLR	F0			;19C4  C2 D5
	LJMP	_1A6B			;19C6  02 1A 6B

_19C9:	MOV	A, #55h			; *** dead?
	LCALL	_1A9B			;19CB  12 1A 9B
	MOV	B, #55h			;19CE  75 F0 55
	LCALL	_1ABC			;19D1  12 1A BC
	JNB	F0, _19DA		;19D4  30 D5 03
	LJMP	_1A98			;19D7  02 1A 98
_19DA:	MOV	A, #0AAh		;19DA  74 AA
	LCALL	_1A9B			;19DC  12 1A 9B
	MOV	A, #55h			;19DF  74 55
	LCALL	_1AA6			;19E1  12 1A A6
	MOV	B, #0AAh		;19E4  75 F0 AA
	LCALL	_1ABC			;19E7  12 1A BC
	JNB	F0, _19F0		;19EA  30 D5 03
	LJMP	_1A24			;19ED  02 1A 24
_19F0:	MOV	B, #55h			;19F0  75 F0 55
	LCALL	_1AF3			;19F3  12 1A F3
	JNB	F0, _19FC		;19F6  30 D5 03
	LJMP	_1A24			;19F9  02 1A 24
_19FC:	MOV	A, #99h			;19FC  74 99
	LCALL	_1A9B			;19FE  12 1A 9B
	MOV	A, #0AAh		;1A01  74 AA
	LCALL	_1AA6			;1A03  12 1A A6
	MOV	B, #99h			;1A06  75 F0 99
	LCALL	_1ABC			;1A09  12 1A BC
	JNB	F0, _1A12		;1A0C  30 D5 03
	LJMP	_1A49			;1A0F  02 1A 49
_1A12:	MOV	B, #0AAh		;1A12  75 F0 AA
	LCALL	_1AF3			;1A15  12 1A F3
	JNB	F0, _1A1E		;1A18  30 D5 03
	LJMP	_1A49			;1A1B  02 1A 49
_1A1E:	LJMP	_1A49			;1A1E  02 1A 49

_1A21		LJMP _1A73

_1A24:	MOV	A, #99h			; *** dead?
	LCALL	_1A9B			;1A26  12 1A 9B
	MOV	B, #99h			;1A29  75 F0 99
	LCALL	_1ABC			;1A2C  12 1A BC
		JNB F0, $+5		; sure we want this???
		LJMP _1A98
_1A35:	MOV	A, #0F0h		;1A35  74 F0
	LCALL	_1A9B			;1A37  12 1A 9B
	MOV	B, #0F0h		;1A3A  75 F0 F0
	LCALL	_1ABC			;1A3D  12 1A BC
	JNB	F0, _1A46		;1A40  30 D5 03
	LJMP	_1A98			;1A43  02 1A 98
_1A46:	SETB	44h			;1A46  D2 44
	RET				;1A48  22

_1A49:	MOV	A, #99h			;1A49  74 99
	LCALL	_1AC7			;1A4B  12 1A C7
	MOV	B, #99h			;1A4E  75 F0 99
	LCALL	_1AD2			;1A51  12 1A D2
		JNB F0, $+5		; sure we want this???
		LJMP _1A98
_1A5A:	MOV	A, #0F0h		;1A5A  74 F0
	LCALL	_1AC7			;1A5C  12 1A C7
	MOV	B, #0F0h		;1A5F  75 F0 F0
	LCALL	_1AD2			;1A62  12 1A D2
	JNB	F0, _1A6B		;1A65  30 D5 03
	LJMP	_1A98			;1A68  02 1A 98
_1A6B:	MOV	A, #0h			;1A6B  74 00
	LCALL	_1AC7			;1A6D  12 1A C7
	SETB	45h			;1A70  D2 45
	RET				;1A72  22

_1A73:	MOV	A, #99h			;1A73  74 99
	LCALL	_1ADD			;1A75  12 1A DD
	MOV	B, #99h			;1A78  75 F0 99
	LCALL	_1AE8			;1A7B  12 1A E8
		JNB F0, $+5		; sure we want this???
		LJMP _1A98
_1A84:	MOV	A, #0F0h		;1A84  74 F0
	LCALL	_1ADD			;1A86  12 1A DD
	MOV	B, #0F0h		;1A89  75 F0 F0
	LCALL	_1AE8			;1A8C  12 1A E8
	JNB	F0, _1A95		;1A8F  30 D5 03
	LJMP	_1A98			;1A92  02 1A 98
_1A95:	SETB	46h			;1A95  D2 46
	RET				;1A97  22
_1A98:	SETB	F0			;1A98  D2 D5
	RET				;1A9A  22


_1A9B		MOV DPTR, #XRAMstart
		MOV R3, #8h
		MOV R2, #0h
		LCALL _1B09
		RET
_1AA6		MOV DPTR, #8800h
		MOV R3, #18h
		MOV R2, #0h
		LCALL _1B09
		RET
_1AB1		MOV DPTR, #0A000h
		MOV R3, #60h
		MOV R2, #0h
		LCALL _1B09
		RET
_1ABC		MOV DPTR, #XRAMstart
		MOV R3, #8h
		MOV R2, #0h
		LCALL _1B10
		RET
_1AC7		MOV DPTR, #XRAMstart
		MOV R3, #20h
		MOV R2, #0h
		LCALL _1B09
		RET
_1AD2		MOV DPTR, #XRAMstart
		MOV R3, #20h
		MOV R2, #0h
		LCALL _1B10
		RET
_1ADD		MOV DPTR, #XRAMstart
		MOV R3, #80h
		MOV R2, #0h
		LCALL _1B09
		RET
_1AE8		MOV DPTR, #XRAMstart
		MOV R3, #20h
		MOV R2, #0h
		LCALL _1B10
		RET
_1AF3		MOV DPTR, #8800h
		MOV R3, #18h
		MOV R2, #0h
		LCALL _1B10
		RET
_1AFE		MOV DPTR, #0A000h
		MOV R3, #60h
		MOV R2, #0h
		LCALL _1B10
		RET

_1B09		MOVX @DPTR, A
		INC DPTR
		DJNZ R2, _1B09
		DJNZ R3, _1B09
		RET

_1B10		MOVX A, @DPTR
		INC DPTR
		CJNE A, B, _1B1C
		DJNZ R2, _1B10
		DJNZ R3, _1B10
		CLR F0
		RET
_1B1C		SETB F0
		RET


OmtiInit_Table1	DB 030h, 0F0h, 08Eh, 035h, 003h				; Omti Registers 10h..15h

OmtiInit_Table2	DB 000h, 000h, 00Fh, 03Fh, 000h, 000h, 000h, 000h
		DB 000h, 033h, 00Eh, 003h, 0AAh, 0D2h, 001h, 0A1h
		DB 080h, 020h, 093h, 081h, 000h, 000h, 000h, 000h	; Omti Registers 20h..37h

OmtiInit_Table3	DB 001h, 000h, 00Bh, 04Eh, 00Ch, 000h, 001h, 0A1h
		DB 001h, 0FEh, 004h, 000h, 004h, 000h, 002h, 000h
		DB 00Ch, 000h, 001h, 0A1h, 001h, 0F8h, 004h, 0E5h
		DB 004h, 000h, 002h, 000h, 00Eh, 04Eh, 001h, 04Eh	; Sequencer state machine

; default geometry values 612/4/17, Precomp 419,
RAMinit_Table	DB 000h, 000h, 000h, 000h				; will be copied into RAM 068h..075h
RAMinit_Table1		DB 002h, 062h, 003h
		DB 010h, 001h, 0A2h, 001h, 0A2h, 000h, 000h

_1B6A	DB	11h
	DB	1Fh
	DB	10h			; 1B6A + 2
	DB	8h
_1B6E		DB 004h
	DB	8h			;1B6F  08
	DB	3h			;1B70  03
	DB	2h			;1B71  02
	DB	10h			;1B72  10
	DB	20h	;' '		;1B73  20
	DB	0Fh			;1B74  0F
	DB	8h			;1B75  08
	DB	40h	;'@'		;1B76  40
	DB	80h	;''		;1B77  80
	DB	3Dh	;'='		;1B78  3D
	DB	20h	;' '		;1B79  20

_1B7A	DB	0h			;1B7A  00
	DB	0h			;1B7B  00
	DB	1h			;1B7C  01
	DB	1h			;1B7D  01
	DB	1Eh			;1B7E  1E
	DB	0h			;1B7F  00
	DB	0h			;1B80  00
	DB	0h			;1B81  00

_1B82	DB "PROAPP  LISA PCB       A   "
	DB 0h, 8h, 0h, 0C9h, 0B0h
	DB	27h			;1BA2  27
	DB	2Ch	;','		;1BA3  2C
	DB	1h			;1BA4  01
	DB	4h			;1BA5  04
	DB	0B0h	;''		;1BA6  B0
	DB	0h			;1BA7  00
	DB	0h			;1BA8  00
	DB	0FFh	;''		;1BA9  FF
	DB	0h			;1BAA  00
	DB	1h			;1BAB  01
	DB	2h			;1BAC  02

_1BAD		LJMP _0405
		LJMP _0480
		LJMP _06ED

_1BB6		DB 000h, 003h, 0C2h, 03Bh, 03Ch, 000h, 01Dh, 008h
		DB 00Ah, 001h, 004h, 006h, 007h, 00Bh, 012h, 015h
		DB 016h, 017h, 025h, 028h, 02Ah, 00Eh, 000h, 01Ah
		DB 0E1h, 0EAh, 0E2h, 02Eh, 02Fh, 005h, 000h, 000h

_1BD6		LJMP _0369
		LJMP _03A4
		LJMP _06FA
		LJMP _06F0
		LJMP _06F5
		LJMP _0747
		LJMP _07D1
		LJMP _03E7
		LJMP _03F8
		LJMP _0373
		LJMP Do_Format
		LJMP _03D2
		LJMP _03E1
		LJMP _04E9
		LJMP _0584
		LJMP _0597
		LJMP _05C0
		LJMP _05F8
		LJMP _0671
		LJMP _06A2
		LJMP _06BE
		LJMP _04EC
		LJMP _0626		; RET
		LJMP _0627
		LJMP _075B
		LJMP _07E2
		LJMP _0786
		LJMP _07E1		; RET
		LJMP _06E8
		LJMP _03CC
		LJMP _07E8
		LJMP _07EE


_1C36	DB "PROAPP REV. 1"
SpareTable	DB "PROFILE      " 	; Device Name
		DB 0h, 0h, 0h		; Device Number
		DB 3h, 90h		; program revision
		DB 0h, 4Ch, 0h		; capacity 10 Meg
		DB 2h, 14h		; 532 bytes per sector
		DB 20h			; 32 spares available
		DB 0h			; 0 spares in use
		DB 0h			; 0 bad blocks

_1C5D		DB 017h, 000h, 000h, 008h, 000h, 000h, 000h, 000h
		DB 000h, 000h, 000h, 000h, 000h, 00Ah, 000h, 000h
		DB 000h, 00Ah, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh
		DB 000h, 00Ah, 000h, 000h, 000h, 000h, 000h, 000h
		DB 000h, 000h, 000h, 00Bh, 000h, 000h, 000h, 000h
		DB 000h, 000h, 000h, 000h, 000h, 000h, 012h
_1C8C		DB 000h
		DB 002h, 063h, 004h, 000h, 001h, 0A2h, 000h, 001h
		DB 0A2h, 000h, 003h, 000h, 002h, 07Fh, 000h, 000h
		DB 000h, 000h, 000h, 000h, 000h


; ***
; *** perform seek to track 0 or 1 (when RecalTo_Trk1 set)
; ***
;
GoTo_Trk0_1	LCALL Wait_DrvRdy
		SETB MFM_DirIn			; move away from track 0
		CLR MFM_HdSel0
		CLR MFM_HdSel1
		CLR MFM_HdSel2
		LCALL Wait_DrvRdy
		JNB F0, GoTo_Trk0_11
		LJMP GoTo_Trk0_Fail		; MFM drive timeout -> exit with error
GoTo_Trk0_11	JNB MFM_SeekCmplt, $		; wait until MFM seek completed
		MOV R0, #0E4h
		MOVX A, @R0
		JNB Acc.5, GoTo_Trk0_12		; skip when on track 0
; set R3.R4 to NumberOf_Cyl + 80
		CLR MFM_DirIn			; move outwards to track 0
		MOV A, #4h
		LCALL Get_PositionVar
		MOV R3, A			; R3 = NumberOf_CylH
		MOV A, #5h
		LCALL Get_PositionVar
		ADD A, #80
		MOV R4, A			; R4 = NumberOf_CylL + 80
		CLR A
		ADDC A, R3			; adjust R3
		INC A
		MOV R3, A
;
GoTo_Trk0_15	MOV A, #1h
		LCALL StepDrive			; do one step
GoTo_Trk0_12	JNB MFM_SeekCmplt, $		; wait until MFM seek completed
		MOV R0, #0E4h
		MOVX A, @R0
		JB Acc.5, GoTo_Trk0_13		; go for next step
; track 0 reached, set Current_Cyl to 0
		MOV R0, #GeometryStart
		CLR A
		MOV @R0, A			; clear Current_CylH
		INC R0
		MOV @R0, A			; clear Current_CylL
		MOV A, #GeometryStart
		ADD A, #0Dh
		MOV R0, A
		MOV A, @R0			; read 075h
		ANL A, #7Fh			; clear bit 7
		MOV @R0, A			; and write back
		JB RecalTo_Trk1, GoTo_Trk0_14	; target was track 0, done
		SETB MFM_DirIn
		MOV A, #1h			;   else do one step back
		LCALL StepDrive
		JNB MFM_SeekCmplt, $		; wait until MFM seek completed
GoTo_Trk0_14	RET				;  and exit
; do next step, and exit if track 0 not reached after NumberOf_Cyl+80 steps
GoTo_Trk0_13	DJNZ R4, GoTo_Trk0_15
		DJNZ R3, GoTo_Trk0_15
GoTo_Trk0_Fail		SETB F0				; error
		RET


_1D05		LJMP _16F2


_1D08		LCALL _1DB3
		JB F0, _1D05
;



; ***
; *** Seek to Target_Cyl
; ***
;
Do_Seek		LCALL SelectDrive1
Do_Seek1	MOV A, #0Dh
		ADD A, #GeometryStart
		MOV R0, A
		MOV A, @R0			; get 75h
		ANL A, #80h
		JZ Do_Seek2			; do home first when bit 7 set
		LCALL GoTo_Trk0_1
Do_Seek2	LCALL Select_MFMhd		; select head
		LCALL Select_MFMprec		; set precompensation
		LCALL PrepareSeek		; set up StepsToGo and direction
		LCALL SelectDrive1
		MOV R0, #Current_CylH
		MOV A, Target_CylH		; update Current_Cyl
		MOV @R0, A
		INC R0
		MOV A, Target_CylL
		MOV @R0, A
		MOV A, StepsToGoL
		CLR C
		SUBB A, #1h			; decrement StepsToGo
		MOV StepsToGoL, A
		MOV A, StepsToGoH
		SUBB A, #0h
		MOV StepsToGoH, A
		JC Do_Seek3			; done?
Do_Seek4	SETB MFM_Step			; do one step
		NOP
		NOP
		CLR MFM_Step
		MOV A, StepsToGoL
		CLR C
		SUBB A, #1
		MOV StepsToGoL, A
		MOV A, StepsToGoH
		SUBB A, #0
		MOV StepsToGoH, A
		JNC Do_Seek4			; until done
		JNB MFM_SeekCmplt, $
Do_Seek3	RET


; ***
; *** wait for MFM drive ready
; *** returns F0 clear when ready, set when timeout
; ***
;
Wait_DrvRdy	MOV R5, #55h
Wait_DrvRdy4	MOV R6, #0FEh
Wait_DrvRdy3	MOV R7, #0FFh
Wait_DrvRdy2	JNB MFM_RdyFault, Wait_DrvRdy1		; drive not ready?
		CLR F0
		RET
Wait_DrvRdy1	DJNZ R7, Wait_DrvRdy2
		DJNZ R6, Wait_DrvRdy3
		DJNZ R5, Wait_DrvRdy4
		SETB F0
		RET


; ***
; *** set MFM_DirIn and StepsToGo according to Current_Cyl, Target_Cyl
; ***
;
PrepareSeek	MOV R0, #Target_CylL
		MOV R1, #Current_CylL
		MOV R2, #2h
		LCALL PrepareSeek1		; determine seek direction
		JC PrepareSeek2			; carry set -> outwards
		SETB MFM_DirIn
		MOV R0, #Target_CylL
		MOV R1, #Current_CylL
		SJMP PrepareSeek3
PrepareSeek2	CLR MFM_DirIn
		MOV R0, #Current_CylL
		MOV R1, #Target_CylL
PrepareSeek3	CLR C
		MOV A, @R0
		SUBB A, @R1
		MOV StepsToGoL, A		; calculate StepsToGo
		DEC R0
		DEC R1
		MOV A, @R0
		SUBB A, @R1
		MOV StepsToGoH, A
		RET
; determine seek direction (sign of Target_Cyl - Current_Cyl)
PrepareSeek1	CLR C
PrepareSeek4	MOV A, @R0
		SUBB A, @R1
		DEC R0
		DEC R1
		DJNZ R2, PrepareSeek4
		RET


_1D9D:	CLR	C			; *** dead?
_1D9E:	CLR	A			;1D9E  E4
	MOVC	A, @A+DPTR		;1D9F  93
	SUBB	A, @R0			;1DA0  96
	INC	DPTR			;1DA1  A3
	INC	R0			;1DA2  08
	DJNZ	R2, _1D9E		;1DA3  DA F9
	RET				;1DA5  22

_1DA6:	MOV	R0, #75h		;1DA6  78 75
	MOV	A, @R0			;1DA8  E6
	ORL	A, #80h			;1DA9  44 80
	MOV	@R0, A			;1DAB  F6
	RET				;1DAC  22


_1DAD:	MOV	64h, #4h		;1DAD  75 64 04
	LJMP	_16F2			;1DB0  02 16 F2


_1DB3		JNB 40h, _1DAD
		MOV 20h, LBA_Hi
		MOV 21h, LBA_Mi
		MOV 22h, LBA_Lo
		MOV A, #7h
		LCALL Get_PositionVar		; get NumberOf_Sec
		INC A				; +1
		PUSH Acc
		MOV A, #6h
		LCALL Get_PositionVar		; get NumberOf_Hd
		INC A				; +1
		MOV B, A
		POP Acc
		MUL AB				; sectors per cylinder
		LCALL _1E69
		PUSH Acc
		MOV A, #7h
		LCALL Get_PositionVar		; get NumberOf_Sec
		INC A				; +1
		MOV B, A
		POP Acc
		DIV AB
		PUSH Acc
		MOV A, #2h
		ADD A, #GeometryStart
		MOV R0, A			; get Current_Hd
		POP Acc
		MOV @R0, A			; calculated head into Current_Hd
		MOV A, #3h
		ADD A, #GeometryStart
		MOV R0, A			; get Current_Sec
		MOV A, B
		MOV @R0, A			; calculated sector into Current_Sec
		JNB 4Ch, _1E3A
		MOV A, LBA_Hi
		ANL A, #60h
		PUSH Acc
		MOV A, 32h
		ANL A, #60h
		MOV B, A
		POP Acc
		CJNE A, B, _1E3A
		MOV A, 32h
		ANL A, #0Fh
		PUSH Acc
		MOV A, #2h
		ADD A, #GeometryStart
		MOV R0, A
		MOV A, @R0			; get Current_Hd
		MOV B, A
		POP Acc
		CJNE A, B, _1E38
		MOV A, 30h
		CJNE A, Target_CylL, _1E38
		MOV A, 31h
		CJNE A, Target_CylH, _1E38
		MOV A, Target_CylL
		MOV 4Fh, A
		MOV A, Target_CylH
		MOV 4Eh, A
		SETB 6Ch
		MOV A, 78h
		ORL A, #20h
		MOV 78h, A
		LJMP _1E44
_1E38		CLR 4Ch
_1E3A		CLR 6Ch
		MOV A, Target_CylL
		MOV 4Fh, A
		MOV A, Target_CylH
		MOV 4Eh, A
_1E44		MOV A, #4h
		LCALL Get_PositionVar		; get NumberOf_CylH
		CJNE A, Target_CylH, _1E4E
		SJMP _1E52
_1E4E		JNC _1E60
		SJMP _1E63
_1E52		MOV A, #5h
		LCALL Get_PositionVar
		CJNE A, Target_CylL, _1E5C
		SJMP _1E60
_1E5C		JNC _1E60
		SJMP _1E63
_1E60		CLR F0
		RET
_1E63		MOV 64h, #21h
		SETB F0
		RET

_1E69:	MOV	1Fh, A			;1E69  F5 1F
	MOV	Target_CylH, #0h
	MOV	Target_CylL, #0h
	MOV	R1, #21h		;1E71  79 21
	MOV	R0, #23h		;1E73  78 23
	MOV	A, 20h			;1E75  E5 20
	ANL	A, #3h			;1E77  54 03
_1E79:	MOV	R2, #8h			;1E79  7A 08
_1E7B:	XCH	A, @R1			;1E7B  C7
	RLC	A			;1E7C  33
	XCH	A, @R1			;1E7D  C7
	RLC	A			;1E7E  33
	JNC	_1E84			;1E7F  50 03
	CLR	C			;1E81  C3
	SJMP	_1E8C			;1E82  80 08
_1E84:	CJNE	A, 1Fh, _1E87		;1E84  B5 1F 00
_1E87:	JNC	_1E8C			;1E87  50 03
	CLR	C			;1E89  C3
	SJMP	_1E8F			;1E8A  80 03
_1E8C:	SUBB	A, 1Fh			;1E8C  95 1F
	SETB	C			;1E8E  D3
_1E8F:	XCH	A, @R0			;1E8F  C6
	RLC	A			;1E90  33
	XCH	A, @R0			;1E91  C6
	DJNZ	R2, _1E7B		;1E92  DA E7
	CJNE	R1, #21h, _1E9D		;1E94  B9 21 06
	MOV	R1, #22h		;1E97  79 22
	MOV	R0, #24h		;1E99  78 24
	SJMP	_1E79			;1E9B  80 DC
_1E9D:	RET				;1E9D  22


; ***
; *** select current MFM drive head
; ***
;
Select_MFMhd	MOV A, #2h
		LCALL Get_PositionVar	; read Current_Hd
Select_MFMhd1	MOV C, Acc.0
		MOV MFM_HdSel0, C
		MOV C, Acc.1
		MOV MFM_HdSel1, C
		MOV C, Acc.2
		MOV MFM_HdSel2, C
		RET


; ***
; *** select MFM precompensation when Current_Cyl > 418
; *** (ignoring the setting entered during HD install !!)
; ***
;
Select_MFMprec	CLR C
		MOV A, #0A2h
		SUBB A, Current_CylL
		MOV A, #1h
		SUBB A, Current_CylH
		MOV MFM_EnPrec, C
		RET


; ***
; *** step MFM drive (Acc) steps
; ***
;
StepDrive	SETB MFM_Step
		NOP
		NOP
		NOP
		NOP
		CLR MFM_Step
		LCALL StepDelay
		DEC A
		JZ StepDrive1
		SJMP StepDrive
StepDrive1	RET
;
StepDelay	MOV R7, #55h
StepDelay2	MOV R6, #44h
StepDelay1	DJNZ R6, StepDelay1
		DJNZ R7, StepDelay2
		RET


; **********************************************************************
;  Enter interactive mode (command line at RS232)
; **********************************************************************
;
GoInteractive	CLR 3h
		LCALL Ser_GetByte
		LCALL SayHello			; print welcome message
		LCALL Ser_SendCR
		JB F0, SysTrkFailed
		LCALL DumpParameters		; and drive parameters
CommandLoop	LCALL Print_Prompt
		LCALL ReceiveCmd		; get command...
		LCALL Ser_SendLF
		LCALL ParseCmd			; ...and execute it
		SJMP CommandLoop
SysTrkFailed	MOV DPTR, #ErrRSysTrk1_Str	; (26B6h)
		LCALL Ser_SendString
		LCALL Ser_SendCR
		SJMP CommandLoop

; *** interpret contents of command line buffer
;
ParseCmd	MOV R0, #0h			; point to first char in buffer (P2 still at 087h)
ParseCmd2	MOVX A, @R0			; get char
		INC R0
		CJNE A, #0Dh, ParseCmd1		; exit when <cr>
		RET
ParseCmd1	CJNE A, #20h, ParseCmd3		; and ignore spaces
		SJMP ParseCmd2
ParseCmd3	MOVX A, @R0			; get next char
		INC R0
		CJNE A, #0Dh, ParseCmd4
		LJMP ParseCmd5			; <cr> -> single-char command
ParseCmd4	CJNE A, #20h, ParseCmd6		; space -> single-char command
ParseCmd5	MOV R7, #0h			; table offset
		LJMP Parse_1Char
;
ParseCmd6	MOVX A, @R0			; get next char
		CJNE A, #0Dh, ParseCmd7
		LJMP ParseCmd8			; <cr> -> dual-char command
ParseCmd7	CJNE A, #20h, Parse_3Char	; space -> dual-char command
ParseCmd8	MOV R7, #0Bh			; table offset
		LJMP Parse_2Char

; execute triple-char command
;
Parse_3Char	MOV R7, #15h			; table offset for triple-char commands
		DEC R0				; back to second cmd char
		DEC R0				; back to first cmd char
		MOV DPTR, #CommandTable3	; (2D16h)
Parse_3Char7	MOVX A, @R0			; get first command char
		MOV B, A
		CLR A
		MOVC A, @A+DPTR			; get first char from table
		CJNE A, #0FFh, Parse_3Char1	; end of table?
		LJMP Parse_Err
Parse_3Char1	CJNE A, B, Parse_3Char2		; test first char
		INC DPTR
		INC R0
		MOVX A, @R0			; get second command char
		MOV B, A
		CLR A
		MOVC A, @A+DPTR			; get second char from table
		CJNE A, #0FFh, Parse_3Char3	; end of table?
		LJMP Parse_Err
Parse_3Char3	CJNE A, B, Parse_3Char4		; test second char
		INC DPTR
		INC R0
		MOVX A, @R0			; get third command char
		MOV B, A
		CLR C
		CLR A
		MOVC A, @A+DPTR			; get third char from table
		CJNE A, #0FFh, Parse_3Char5	; end of table?
		LJMP Parse_Err
Parse_3Char5	CJNE A, B, Parse_3Char6		; test third char
		LJMP Parse_Go			; match!
Parse_3Char2	INC DPTR
		INC DPTR
		INC DPTR
		INC R7
		LJMP Parse_3Char7		; next one
Parse_3Char4	INC DPTR
		INC DPTR
		INC R7
		DEC R0
		LJMP Parse_3Char7		; next one
Parse_3Char6	INC DPTR
		DEC R0
		INC R7
		DEC R0
		LJMP Parse_3Char7		; next one

; execute dual-char command
;
Parse_2Char	DEC R0				; back to last cmd char
		DEC R0				; back to first cmd char
		MOV DPTR, #CommandTable2	; (2D01h)
Parse_2Char5	MOVX A, @R0			; get first command char
		MOV B, A
		CLR A
		MOVC A, @A+DPTR			; get first char from table
		CJNE A, #0FFh, Parse_2Char1	; end of table?
		LJMP Parse_Err
Parse_2Char1	CJNE A, B, Parse_2Char2		; test first char
		INC DPTR
		INC R0
		MOVX A, @R0			; get second command char
		MOV B, A
		CLR A
		MOVC A, @A+DPTR			; get second char from table
		CJNE A, #0FFh, Parse_2Char3	; end of table?
		LJMP Parse_Err
Parse_2Char3	CJNE A, B, Parse_2Char4		; test second char
		LJMP Parse_Go			; match!
Parse_2Char2	INC DPTR
		INC R7
		INC DPTR
		LJMP Parse_2Char5		; next one
Parse_2Char4	INC DPTR
		INC R7
		DEC R0
		LJMP Parse_2Char5		; next one

; execute single-char command
;
Parse_1Char	DEC R0				; back to <cr>
		DEC R0				; back to command char
		MOV DPTR, #CommandTable1	; (2CF5h)
Parse_1Char3	MOVX A, @R0			; get command char
		MOV B, A
		CLR A
		MOVC A, @A+DPTR			; get char from table
		CJNE A, #0FFh, Parse_1Char1	; end of table?
		LJMP Parse_Err
Parse_1Char1	CJNE A, B, Parse_1Char2
		LJMP Parse_Go			; match!
Parse_1Char2	INC DPTR
		INC R7
		LJMP Parse_1Char3		; next one
;
Parse_Go	MOV DPTR, #JumpTable		; (2D1Ah)
		MOV A, R7
		CLR C
		MOV B, #3h
		MUL AB				; calculate position in jump table
		LCALL Parse_Go1
		MOV R0, 3Ch			; restore char pointer,
		MOV P2, #87h			;  restore P2,
		LJMP ParseCmd2			;  and parse the next command
Parse_Go1	INC R0
		MOV 3Ch, R0			; save char pointer
		MOV P2, #0h
		JMP @A+DPTR			;  and go!
;
; miss error message and crash into head parking routine (!)
Parse_Err	MOV DPTR, #Jump_OhOh		; (2D5Ch)
		MOV A, TH1			; should be 0F3h
		ANL A, #7h
		CLR C
		MOV B, #3h
		MUL AB				; 3x3 is 9
		JMP @A+DPTR			; this should send "try again"-message and return

; *** print welcome message
;
SayHello	MOV DPTR, #Hello_Str
		LCALL Ser_SendString
		RET


; ************************************************************************
;  Hard Disk Installer
; ************************************************************************
;
HD_Installer	MOV DPTR, #NoDrvOnline_Str	; (2918h)
		LCALL Ser_SendString
		LCALL Ser_SendCR
;
; ask for drive geometry data
HD_Installer4	LCALL Print_EnterStr
		MOV P2, #XRAMstart / 256
		MOV R1, #XRAMstart # 256
		MOV A, #0AAh
		MOVX @R1, A
		INC R1
		MOVX @R1, A			; write "AAAA" signature into RAM
		MOV A, #0
		MOV R7, #4
HD_Installer1	INC R1
		MOVX @R1, A			; followed by 4x 0
		DJNZ R7, HD_Installer1
		SETB IntegerFlag
; get number of cylinders -2
		MOV DPTR, #LastCyl_Str		; (29A6h)
		LCALL Ser_SendString
		MOV R7, #0
HD_Installer5	LCALL Ser_GetByte		; get character
		LCALL Ser_SendChar
		CJNE A, #0Dh, HD_Installer2
		SJMP HD_Installer3		; done if <cr>
HD_Installer2	INC R7				; increment number of digits
		LCALL TestForDigit
		JB F0, HD_Installer4		; retry when error
		INC R1
		MOVX @R1, A			; write value into RAM
		SJMP HD_Installer5		; and get next one
HD_Installer3	LCALL ConvertToValue		; convert digits to value
		MOV A, #0Ah
		LCALL Ser_SendChar
; get number of heads -1
		LCALL Print_EnterStr
		CLR IntegerFlag
		MOV DPTR, #NumHeads_Str		; (29BFh)
		LCALL Ser_SendString
		LCALL Ser_GetByte		; get character
		LCALL Ser_SendChar
		LCALL TestForDigit
		JB F0, HD_Installer4		; retry when error
		MOVX @R1, A			; store value immediately into RAM
		LCALL Ser_GetByte		; ignore <cr>
		LCALL Ser_SendCR
; get number of sectors -1
		LCALL Print_EnterStr
		MOV DPTR, #NumSct_Str		; (29D3h)
		LCALL Ser_SendString
		MOV R7, #0h
HD_Installer9 	LCALL Ser_GetByte		; get character
		LCALL Ser_SendChar
		CJNE A, #0Dh, HD_Installer6
		SJMP HD_Installer7		; done if <cr>
HD_Installer6	INC R7				; increment number of digits
		LCALL TestForDigit
		JNB F0, HD_Installer8
		LJMP HD_Installer4		; retry when error
HD_Installer8	INC R1
		MOVX @R1, A			; write value into RAM
		SJMP HD_Installer9		; and get next one
HD_Installer7	LCALL ConvertToValue		; convert digits to value
		MOV A, #0Ah
		LCALL Ser_SendChar
; get number of cylinder where precompensation starts -1
		LCALL Print_EnterStr
		SETB IntegerFlag
		MOV DPTR, #PrecompCyl_Str	; (29E9h)
		LCALL Ser_SendString
		MOV R7, #0h
		DEC R1
HD_Installer13	LCALL Ser_GetByte		; get character
		LCALL Ser_SendChar
		CJNE A, #0Dh, HD_Installer10
		SJMP HD_Installer11		; done if <cr>
HD_Installer10	INC R7				; increment number of digits
		LCALL TestForDigit
		JNB F0, HD_Installer12
		LJMP HD_Installer4		; retry when error
HD_Installer12	INC R1
		MOVX @R1, A			; write value into RAM
		SJMP HD_Installer13		; and get next one
HD_Installer11	LCALL ConvertToValue		; convert digits to value
		MOV A, #0Ah
		LCALL Ser_SendChar
; get LUN status byte
		LCALL Print_EnterStr
		CLR IntegerFlag
		MOV DPTR, #LunStat_Str		; (2A06h)
		LCALL Ser_SendString
		MOV R7, #0h
		DEC R1
HD_Installer17	LCALL Ser_GetByte		; get character
		LCALL Ser_SendChar
		CJNE A, #0Dh, HD_Installer14
		SJMP HD_Installer15		; done if <cr>
HD_Installer14	INC R7				; increment number of digits
		LCALL TestForDigit
		JNB F0, HD_Installer16
		LJMP HD_Installer4		; retry when error
HD_Installer16	INC R1
		MOVX @R1, A			; write value into RAM
		SJMP HD_Installer17		; and get next one
HD_Installer15	 LCALL	ConvertToValue
		MOV A, #0Ah
		LCALL Ser_SendChar
; get Flag byte
		LCALL Print_EnterStr
		MOV DPTR, #FlagByte_Str		; (2A17h)
		LCALL Ser_SendString
		MOV R7, #0h
		DEC R1
HD_Installer21	LCALL Ser_GetByte		; get character
		LCALL Ser_SendChar
		CJNE A, #0Dh, HD_Installer18
		SJMP HD_Installer19		; done if <cr>
HD_Installer18	INC R7				; increment number of digits
		LCALL TestForDigit
		JNB F0, HD_Installer20
		LJMP HD_Installer4		; retry when error
HD_Installer20	INC R1
		MOVX @R1, A			; write value into RAM
		SJMP HD_Installer21		; and get next one
HD_Installer19	LCALL ConvertToValue
		MOV A, #0Ah
		LCALL Ser_SendChar
; get Interleave
		LCALL Print_EnterStr
		MOV DPTR, #Interleave_Str	; (2A22h)
		LCALL Ser_SendString
		LCALL Ser_GetByte
		LCALL Ser_SendChar
		SUBB A, #30h			; convert to digit
		MOV Interleave, A		; ignore <cr>
		LCALL Ser_GetByte
		LCALL Ser_SendChar
		MOV A, #0Ah
		LCALL Ser_SendChar
; calculate capacity and set up VolumeSizeM..L
		MOV R1, #8h
		MOVX A, @R1			; get number of heads -1
		INC A
		MOV B, A
		INC R1
		MOVX A, @R1			; get number of sectors -1
		INC A
		MUL AB				; sectors per cylinder
		MOV R6, A			;  into R6
		MOV VolumeSizeH, #0h
		MOV VolumeSizeM, #0h
		MOV VolumeSizeL, #0h
		MOV R1, #6h
		MOVX A, @R1			; get cylinder MSB
		MOV B, A			;  into B
		INC R1
		MOVX A, @R1			; get cylinder LSB
		CLR C
		ADD A, #0h
		MOV R4, A			;  into R4
		MOV A, B
		ADDC A, #0h
		MOV B, A
HD_Installer22	CLR C
		MOV A, R4
		ADDC A, VolumeSizeL
		MOV VolumeSizeL, A
		MOV A, B
		ADDC A, VolumeSizeM
		MOV VolumeSizeM, A
		MOV A, VolumeSizeH
		ADDC A, #0h
		MOV VolumeSizeH, A		; add cylinder number to VolumeSize
		DJNZ R6, HD_Installer22		;  'sectors per cylinder' times
; initialize geometry variables
		LCALL Ser_SendCR
		MOV DPTR, #InitSysTrk_Str	; (277Ch)
		LCALL Ser_SendString
		MOV P2, #Omti_base
		MOV R2, #0h
		MOV R3, #0h
		LCALL Omti_DMAdrSet		; set DMA address to 0000h
		MOV DPTR, #XRAMstart +2
		MOV R6, #0h
		MOV R0, #GeometryStart
		MOV R7, #14
HD_Installer31	MOVX A, @DPTR			; get value from RAM buffer
		MOV @R0, A			; and set up geometry variables
		INC DPTR
		INC R0
		INC R6
		MOV A, R6
		CJNE A, #10, HD_Installer30	; do this for the first 12 variables
		CLR A
		MOV @R0, A			; and clear the last two
		INC R0
		MOV @R0, A
		DEC R7
		DEC R7
HD_Installer30	DJNZ R7, HD_Installer31
; initialize some more variables and setup drive
		CLR A
		MOV 76h, A
		MOV 78h, A
		MOV 77h, A
		MOV 65h, A
		MOV 2Dh, A
		MOV DPTR, #XRAMstart
		MOV R6, #100
		MOV R7, #0h
		LCALL MFM_WriteSctr		; write 100 bytes into DMA channel 3
		MOV 56h, #0Ah
		MOV LBA_Hi, #0h
		MOV LBA_Mi, #0h
		MOV LBA_Lo, #0h
		MOV 5Ah, #1h
		MOV 5Bh, #0h
		SETB 6Fh
		LCALL _0EF8			; ???
		JNB F0, HD_Installer32
		LJMP WrtSysTrkFail
HD_Installer32	MOV 5Ah, Interleave
		MOV 5Bh, #0h
		LCALL _0C2D			; ???
		CLR RecalTo_Trk1
		LCALL Do_Rezero
		MOV DPTR, #Formatting_Str	; (27D4h)
		LCALL Ser_SendCR
		LCALL Ser_SendString
		LCALL Do_Format
		LCALL Ser_SendCR
		MOV DPTR, #Rezeroing_Str	; (2843h)
		LCALL Ser_SendString
		LCALL Do_Rezero
		LCALL Ser_SendCR
; get defect list
HD_Installer55	MOV DPTR, #EnterDefL_Str	; (26DEh)
		LCALL Ser_SendString
		LCALL Ser_SendCR
		MOV DefectList_Ptr, #0h		; zero defect list index
HD_Installer53	MOV tmp_Cyl2, #30h		; preload upper digits of tmp_Cyl with '0'
		MOV tmp_Cyl3, #30h
		MOV tmp_Cyl4, #30h
		LCALL Ser_SendCR
		MOV DPTR, #Hd_Str		; (26D1h)
		LCALL Ser_SendString
		LCALL Ser_GetByte		; get character
		CJNE A, #0Dh, HD_Installer40
		LJMP HD_Installer41		; done if <cr>
HD_Installer40	CJNE A, #39h, HD_Installer42
		LJMP HD_Installer43		; = '9'
HD_Installer42	JNC HD_Installer44		; > '9' -> bad entry
		CJNE A, #30h, HD_Installer45
		LJMP HD_Installer43		; = '0'
HD_Installer45	JC HD_Installer44		; < '0' -> bad entry
HD_Installer43	MOV tmp_Hd, A
		LCALL Ser_SendChar
		MOV A, #20h
		LCALL Ser_SendChar
		MOV DPTR, #Trk_Str		; (26D7h)
		LCALL Ser_SendString
		LCALL Ser_GetByte		; get character
		CJNE A, #0Dh, HD_Installer46
		LJMP HD_Installer41		; done if <cr>
HD_Installer46	MOV R7, #4h
HD_Installer52	MOV R1, #40h
		CJNE A, #39h, HD_Installer47	; = '9'
		LJMP HD_Installer48
HD_Installer47	JNC HD_Installer44		; > '9' -> bad entry
		CJNE A, #30h, HD_Installer49	; = '0' -> bad entry
		LJMP HD_Installer48
HD_Installer49	JC HD_Installer44		; < '0' -> bad entry
HD_Installer48	MOV B, A
		LCALL HD_Inst_Shift		; shift digits upwards in buffer
		INC R1
		MOV A, B
		MOV @R1, A			; and insert new one at lower end
		LCALL Ser_SendChar
		LCALL Ser_GetByte		; get next character
		CJNE A, #0Dh, HD_Installer50
		LJMP HD_Installer51		; <cr> -> track number complete
;
; shift digits towards upper buffer end
HD_Inst_Shift	MOV R5, #3h
HD_Inst_Shift1	MOV A, @R1			; tmp_Cyl2 -> tmp_Cyl1
		INC R1				; tmp_Cyl3 -> tmp_Cyl2
		MOV @R1, A			; tmp_Cyl4 -> tmp_Cyl3
		DEC R1
		DEC R1
		DJNZ R5, HD_Inst_Shift1
		RET
;
HD_Installer50	DJNZ R7, HD_Installer52		; process next character
;
; "Bad Entry" - Message
HD_Installer44	LCALL Ser_SendCR
		MOV DPTR, #BadEntry_Str		; (272Ch)
		LCALL Ser_SendString
		LCALL Ser_SendCR
		LJMP HD_Installer53		; get next bad track entry
;
HD_Installer51	LCALL Calculate_LBA
		LCALL Enter_DefectLBA
		LJMP HD_Installer53		; get next bad track entry
;
HD_Installer54	LJMP HD_Installer55
; done with defect list, get confirmation
HD_Installer41	LCALL Ser_SendCR
		MOV DPTR, #IsOk_Str		; (2707h)
		LCALL Ser_SendString
		LCALL Ser_GetByte
		CJNE A, #'Y', HD_Installer54	; redo entries when not ok
		LCALL _0C2D			; ???
		LCALL Ser_SendCR
		LJMP HD_Installer60
;
; Verify drive
HD_Installer62	LCALL Ser_SendCR
		MOV DPTR, #Verifying_Str	; (2882h)
		LCALL Ser_SendString
		MOV A, #7h
		LCALL Get_PositionVar		; get NumberOf_Sec
		MOV DefectList_Ptr, #0h
		INC A
		MOV 5Ah, A
		MOV 56h, #8h
		MOV LBA_Hi, #0h
		MOV LBA_Mi, #0h
		MOV LBA_Lo, #0h
		MOV 5Bh, #80h
		SETB 2Dh
HD_Installer66	LCALL _0EED			; ???
		JNB F0, HD_Installer65
		LCALL Ser_SendCR
		MOV DPTR, #TooManyBad_Str	; (2855h)
		LCALL Ser_SendString
HD_Installer67	CLR 2Dh
		LCALL Ser_SendCR
		RET				; exit, installation aborted
;
HD_Installer65	MOV A, LBA_Mi
		CJNE A, VolumeSizeM, HD_Installer66
		MOV A, LBA_Hi
		CJNE A, VolumeSizeH, HD_Installer66
		CLR 2Dh
		JB 2Ch, HD_Installer67
		LJMP HD_Installer70		; go, init system track
;
; Reassign bad blocks
HD_Installer60	CLR 2Ch
		MOV 5Bh, #0h
		LCALL Ser_SendCR
		MOV DPTR, #Rezeroing_Str
		LCALL Ser_SendString
		LCALL Do_Rezero
		MOV A, DefectList_Ptr
		JZ HD_Installer61		; no defects, done
		LCALL Ser_SendCR
		MOV DPTR, #ReassignBad_Str	; (2818h)
		LCALL Ser_SendString
		MOV 3Bh, #0h			; initialize pointer
HD_Installer64	SETB 6Fh
		MOV DPH, #XRAMstart / 256
		MOV DPL, 3Bh
		CLR C
		MOV A, 3Bh
		ADD A, #3h			; increment pointer
		MOV 3Bh, A
		MOVX A, @DPTR			; get defect LBA from list
		MOV LBA_Hi, A
		INC DPTR
		MOVX A, @DPTR
		MOV LBA_Mi, A
		INC DPTR
		MOVX A, @DPTR
		MOV LBA_Lo, A
		MOV 5Ah, #0h
		MOV 56h, #0Eh
		CLR C
		MOV A, #7h
		LCALL Get_PositionVar		; get NumberOf_Sec
		INC A				; +1
		MOV B, A
		MOV A, VolumeSizeL
		SUBB A, B			; decrement volume size by amount of
		MOV VolumeSizeL, A		;  sectors in bad track
		MOV A, VolumeSizeM
		SUBB A, #0h
		MOV VolumeSizeM, A
		MOV A, VolumeSizeH
		SUBB A, #0h
		MOV VolumeSizeH, A
		MOV 5Ch, VolumeSizeH
		MOV 5Dh, VolumeSizeM
		MOV 5Eh, VolumeSizeL
		MOV 5Fh, #0h
		LCALL _04EC			; reassign block
		JNB F0, HD_Installer63
		MOV A, 64h
		LCALL Ser_SendByte
		LJMP HD_Installer61		; done, go to verify
;
HD_Installer63	LCALL Do_Rezero
		MOV A, DefectList_Ptr
		CLR C
		SUBB A, #3h			; decrement defect list pointer
		MOV DefectList_Ptr, A
		JNZ HD_Installer64		; and process next defect
;
HD_Installer61	LCALL Ser_SendCR
		MOV DPTR, #Rezeroing_Str
		LCALL Ser_SendString
		LCALL Do_Rezero
		LJMP HD_Installer62
;
; initialize system track
HD_Installer70	LCALL Ser_SendCR
		MOV DPTR, #Rezeroing_Str
		LCALL Ser_SendString
		SETB RecalTo_Trk1
		LCALL Do_Rezero
		MOV DPTR, #InitLSysTrk_Str	; (279Ah)
		LCALL Ser_SendCR
		LCALL Ser_SendString
; copy spare table to RAM
		MOV P2, #XRAMstart / 256
		MOV R0, #XRAMstart # 256
		MOV R7, #26			; length is 26 bytes
		MOV DPTR, #SpareTable		; (1C43h)
		MOV R6, #18
HD_Installer72	MOV A, R0
		MOVC A, @A+DPTR			; copy from ROM
		CPL A
		MOVX @R0, A			;  to RAM
		INC R0
		DJNZ R6, HD_Installer71		; skip capacity bytes,
		MOV A, VolumeSizeH
		CPL A
		MOVX @R0, A			; take these from VolumeSize
		INC R0
		MOV A, VolumeSizeM
		CPL A
		MOVX @R0, A
		INC R0
		MOV A, VolumeSizeL
		CPL A
		MOVX @R0, A
		INC R0
		DEC R7
		DEC R7
		DEC R7
HD_Installer71	DJNZ R7, HD_Installer72
;
		MOV P2, #Omti_base
		MOV R2, #0h
		MOV R3, #0h
		LCALL Omti_DMAdrSet		; set DMA address to 0000h
		MOV DPTR, #XRAMstart
		MOV R6, #100
		MOV R7, #0h
		LCALL MFM_WriteSctr		; write 100 bytes into DMA channel 3
		MOV 56h, #0Ah
		MOV LBA_Hi, #0h
		MOV LBA_Mi, #0h
		MOV LBA_Lo, #1h
		MOV 5Ah, #1h
		MOV 5Bh, #0h
		LCALL _0EF8			; ???
		JNB F0, InstallFinished
		LJMP WrtSysTrkFail
; Success, restart unit
InstallFinished	LCALL Ser_SendCR
		MOV DPTR, #HDinstCpl_Str	; (27E8h)
		LCALL Ser_SendString
		MOV DPTR, #Restarting_Str	; (27BDh)
		LCALL Ser_SendCR
		LCALL Ser_SendString
		LCALL Ser_SendCR
		LJMP MainStart


RdSysTrkFail	LCALL Ser_SendCR
		MOV DPTR, #ErrRSysTrk_Str	; (26B6h)
		LCALL Ser_SendString
		LCALL Ser_SendCR
		RET


WrtSysTrkFail	LCALL Ser_SendCR
		MOV DPTR, #ErrWSysTrk_Str	; (28CAh)
		LCALL Ser_SendString
		LCALL Ser_SendCR
		RET


; ************************************************************************
;  Dump drive parameters from RAM buffer (at 8000h) to RS232
;  Invoke hard disk installer when AAAA signature missing
; ************************************************************************
;
DumpParms1	LJMP HD_Installer		; -> install drive first!
; check RAM for boot block AAAA signature
DumpParameters	MOV P2, #XRAMstart / 256
		MOV R0, #XRAMstart # 256
		MOVX A, @R0			; get first byte from RAM buffer
		CJNE A, #0AAh, DumpParms1	;  no AAh -> drive offline
		INC R0
		MOVX A, @R0			; next byte,
		CJNE A, #0AAh, DumpParms1	;  same question
; Drive 0 found to be online
		MOV DPTR, #Drv0Online_Str	; (293Ch)
		LCALL Ser_SendString
		LCALL Ser_SendCR
		MOV DPTR, #CurrCyl_Str		; (2976h)
		LCALL Ser_SendString
		INC R0
		MOVX A, @R0			; byte 02 current Cylinder MSB
		LCALL Ser_SendByte
		INC R0
		MOVX A, @R0			; byte 03 current Cylinder LSB
		LCALL Ser_SendByte
		LCALL Ser_SendCR
		MOV DPTR, #CurrHd_Str		; (2988h)
		LCALL Ser_SendString
		INC R0
		MOVX A, @R0			; byte 04 current Head
		LCALL Ser_SendByte
		LCALL Ser_SendCR
		MOV DPTR, #CurrSec_Str		; (2996h)
		LCALL Ser_SendString
		INC R0
		MOVX A, @R0			; byte 05 current Sector
		LCALL Ser_SendByte
		LCALL Ser_SendCR
		MOV DPTR, #LastCyl_Str
		LCALL Ser_SendString
		MOV A, #8h
		LCALL Ser_SendChar		; send 3x backspace to remove " -2"
		LCALL Ser_SendChar
		LCALL Ser_SendChar
		INC R0				; byte 06 LastCylinder-1 MSB
		INC R0				; byte 07 LastCylinder-1 LSB
		MOVX A, @R0
		CLR C
		ADD A, #1h
		MOVX @R0, A			; increment byte 07
		DEC R0
		MOVX A, @R0
		ADDC A, #0h			; increment byte 06 if overflow occured
		LCALL Ser_SendByte		; this is LastCylinder MSB
		INC R0
		MOVX A, @R0
		LCALL Ser_SendByte		; LastCylinder LSB
		LCALL Ser_SendCR
		MOV DPTR, #NumHeads_Str
		LCALL Ser_SendString
		MOV A, #8h
		LCALL Ser_SendChar		; send 3x backspace to remove " -1"
		LCALL Ser_SendChar
		LCALL Ser_SendChar
		INC R0				; byte 08 LastHead-1
		MOVX A, @R0
		INC A
		LCALL Ser_SendByte
		LCALL Ser_SendCR
		MOV DPTR, #NumSct_Str
		LCALL Ser_SendString
		MOV A, #8h
		LCALL Ser_SendChar		; send 3x backspace to remove " -1"
		LCALL Ser_SendChar
		LCALL Ser_SendChar
		INC R0				; byte 09 NumberOfSectors-1
		MOVX A, @R0
		INC A
		LCALL Ser_SendByte
		LCALL Ser_SendCR
		MOV DPTR, #PrecompCyl_Str
		LCALL Ser_SendString
		MOV A, #8h
		LCALL Ser_SendChar		; send 3x backspace
		LCALL Ser_SendChar
		LCALL Ser_SendChar
		INC R0				; byte 0A PrecompCylinder MSB
		MOVX A, @R0
		LCALL Ser_SendByte
		INC R0				; byte 0B PrecompCylinder LSB
		MOVX A, @R0
		LCALL Ser_SendByte
		LCALL Ser_SendCR
		MOV DPTR, #LunStat_Str
		LCALL Ser_SendString
		INC R0				; byte 0C LUNstatus
		MOVX A, @R0
		LCALL Ser_SendByte
		LCALL Ser_SendCR
		MOV DPTR, #FlagByte_Str
		LCALL Ser_SendString
		INC R0				; byte 0D FlagByte
		MOVX A, @R0
		LCALL Ser_SendByte
		LCALL Ser_SendCR
		MOV P2, #0h
		RET


; ***
; *** send byte as two ASCII chars to RS232
; ***
;
Ser_SendByte	LCALL SplitHex
		LCALL Ser_SendChar
		MOV A, B
		LCALL Ser_SendChar
		RET


; ***
; *** put LBA bytes into RAM buffer and increment defect list pointer
; ***
;
Enter_DefectLBA	MOV DPH, #XRAMstart / 256
		MOV DPL, DefectList_Ptr
		MOV A, LBA_Hi
		MOVX @DPTR, A
		MOV A, LBA_Mi
		INC DPTR
		MOVX @DPTR, A
		MOV A, LBA_Lo
		INC DPTR
		MOVX @DPTR, A
		CLR C
		MOV A, DefectList_Ptr
		ADD A, #3h			; increment defect list pointer
		MOV DefectList_Ptr, A
		RET


; ***
; *** Print the word "Enter" to RS232
; ***
;
Print_EnterStr	MOV DPTR, #Enter_Str		; (296Fh)
		LCALL Ser_SendString
		RET


; ***
; *** replace string of figures in RAM with integer (bit 47=1) or byte (bit 47=0)
; *** R7: number of digits, R1 points to last character in RAM buffer
; ***
;
ConvertToVal2	CJNE A, #2, ConvertToVal3	; 1 digit
		LJMP ConvertToVal4		; 2 digits
;
ConvertToValue	MOV A, R7			; number of digits
		MOV R6, A
		DEC R7
		DEC R6
		MOV R4, #0h			; zero Result
		MOV R5, #0h
ConvertToVal1	DEC R1				; set pointer to first character
		DJNZ R7, ConvertToVal1
		CJNE A, #3, ConvertToVal2
		MOV B, #100			; 3 digits
		MOVX A, @R1
		MUL AB
		MOV R4, A			; first digit x100 into result
		MOV R5, B
		INC R1
ConvertToVal4 	MOV B, #10
		MOVX A, @R1			; second digit x10
		MUL AB
		CLR C
		ADDC A, R4
		MOV R4, A			; add to result
		MOV A, R5
		ADDC A, #0h
		MOV R5, A
		INC R1
ConvertToVal3	MOVX A, @R1
		CLR C
		ADDC A, R4
		MOV R4, A			; add third digit to result
		MOV A, R5
		ADDC A, #0h
		MOV R5, A
		MOV A, R6
		MOV R7, A			; restore R7
ConvertToVal5	DEC R1				; set pointer to first character
		DJNZ  R6, ConvertToVal5
		JNB IntegerFlag, ConvertToVal6
		MOV A, R5
		MOVX @R1, A			; store MSB
		INC R1
ConvertToVal6	MOV A, R4
		MOVX @R1, A			; store LSB
		INC R1
		RET


; ***
; *** Test character in Acc for number. Returns Acc-30h and F0 clear when ok,
; *** F0 set when error (i.e. Acc > 39h)
; ***
;
TestForDigit	CLR F0				; no error
		CJNE A, #3Ah, TestForDigit1
TestForDigit1	JNC TestForDigit2		; above 3Ah -> error
		CLR C
		SUBB A, #30h			; subtract 30h to get number
		RET
TestForDigit2	MOV DPTR, #OhOh_Str 		; (269Dh)
		LCALL Ser_SendCR
		LCALL Ser_SendString
		LCALL Ser_SendCR
		SETB F0				; F0 set -> operation unsuccesful
		RET


; ***
; *** send string at DPTR to RS232. String is terminated with 0FFh
; ***
;
Ser_SendString	CLR A
		MOVC A, @A+DPTR
		INC DPTR
		CJNE A, #0FFh, Ser_SendString1
		RET
Ser_SendString1	LCALL Ser_SendChar
		SJMP Ser_SendString

Print_Prompt	MOV A, #'&'
		LCALL Ser_SendChar
		RET

; ***
; *** receive command from RS232 and write it into RAM buffer (at 08700h)
; ***
;
ReceiveCmd	CLR F0			; no error up to now...
		MOV P2, #87h
		MOV R0, #0h		; pointer to buffer start at 8700h
RecCmd1		LCALL Ser_GetByte
		LCALL RecCmd2		; check for special characters
		MOVX @R0, A		; put char into buffer
		INC R0
		MOV A, R0
		CJNE A, #0FFh, RecCmd1	; get next char until buffer full
		SETB F0			; buffer full -> operation unsuccesful
		RET
;
RecCmd2		LCALL Ser_SendChar	; echo char back
		CJNE A, #8h, RecCmd3	; check for backspace
		SJMP RecCmd4		;  -> decrement pointer
RecCmd3		CJNE A, #0Dh, RecCmd5	; check for CR
		SJMP RecCmd6		;  -> done
RecCmd5		RET


; ***
; *** set up RS232 (Timer 1 2400bps 8 bit no parity)
; ***
;
Ser_Init	MOV SCON, #52h
		MOV TMOD, #21h
		MOV TH1, #0F3h
		SETB TR1
		RET


; ***
; *** split the byte in A into two hex characters in A, B
; ***
;
SplitHex	MOV B, A
		SWAP A
		ANL A, #0Fh
		CJNE A, #0Ah, SplitHex1
SplitHex3	ADD A, #37h
		SJMP SplitHex2
SplitHex1	JNC SplitHex3
		ADD A, #30h
SplitHex2	PUSH Acc
		MOV A, B
		ANL A, #0Fh
		CJNE A, #0Ah, SplitHex4
SplitHex6	ADD A, #37h
		SJMP SplitHex5
SplitHex4	JNC SplitHex6
		ADD A, #30h
SplitHex5	MOV B, A
		POP Acc
		RET


A_Return	RET


; process backspace
RecCmd4		MOV A, R0
		JZ RecCmd7		; already at beginning?
		DEC R0			; no, decrement pointer
RecCmd7		POP Acc
		POP Acc			; zap return address
		LJMP RecCmd1		;  and go back to main receive loop
; process CR
RecCmd6		CLR F0			; clear F0 again to make sure it's cleared
		MOVX @R0, A		; store CR into buffer
		POP Acc
		POP Acc			; zap one retun level
		RET			;  and jump directly to calling routine


; ***
; *** get one byte from RS232
; ***
;
Ser_GetByte	JNB RI, Ser_GetByte
		MOV A, SBUF
		CLR RI
		RET


; ***
; *** send one byte (char) to RS232
; ***
;
Ser_SendChar	JNB TI, Ser_SendChar
		CLR TI
		MOV SBUF, A
		RET
; send CRLF
Ser_SendCR 	PUSH	Acc
		MOV	A, #0Dh
		LCALL	Ser_SendChar
		POP	Acc
Ser_SendLF	PUSH	Acc
		MOV	A, #0Ah
		LCALL	Ser_SendChar
		POP	Acc
		RET
NotYet_1	RET


C_Return	RET


; ***
; *** any illegal command will end up here
; ***
;
Cmd_OhOh	MOV DPTR, #OhOh_Str
		LJMP Cmd_OhOh1
Cmd_OhOh1	LCALL Ser_SendString
		MOV DPTR, #TryAgain_Str		; (28E8h)
		LCALL Ser_SendString
		LCALL Ser_SendCR
		RET


_2641		MOV 20h, #0h			; *** dead?
		MOV 21h, Target_CylH
		MOV 22h, Target_CylL
		MOV A, #64h
		LCALL _1E69
		MOV B, A
		MOV A, Target_CylL
		ADD A, #30h
		LCALL Ser_SendChar
		MOV A, B
		MOV 21h, #0h
		MOV 22h, A
		MOV A, #0Ah
		LCALL _1E69
		MOV B, A
		MOV A, Target_CylL
		ADD A, #30h
		LCALL Ser_SendChar
		MOV A, B
		ADD A, #30h
		LCALL Ser_SendChar
		RET


Hello_Str	DB "Lisa Diagnostic Utility Routines Rev. D", 0FFh
OhOh_Str	DB "oooh,oooh", 0FFh
HDParked_Str	DB "HEADS PARKED!!", 0FFh
ErrRSysTrk1_Str	DB "Error reading system track", 0FFh
Hd_Str		DB "Head ", 0FFh
Trk_Str		DB "Track ", 0FFh
EnterDefL_Str	DB "Enter Defect list .. Null input to exit ", 0FFh
IsOk_Str	DB "Is the above input(s) ok ? (yes/no) ", 0FFh
BadEntry_Str	DB "Bad input try again...", 0FFh
Lim16M_Str	DB "Limiting capacity to 16Mbytes", 0FFh
LimReset_Str	DB "Limited capacity bit reset", 0FFh
InitSysTrk_Str	DB "Initializing the system track", 0FFh
InitLSysTrk_Str	DB "Initializing the lisa system track", 0FFh
Restarting_Str	DB "RESTARTING SYSTEM !!!!", 0FFh
Formatting_Str	DB "Formatting unit....", 0FFh
HDinstCpl_Str	DB "Hard disk install complete.. Ready for MacWorks", 0FFh
ReassignBad_Str	DB "Now reassigning bad blocks .. Please Wait.", 0FFh
Rezeroing_Str	DB "Drive rezeroing..", 0FFh
TooManyBad_Str	DB "Drive has over 30 defects replace drive !!!!", 0FFh
Verifying_Str	DB "Verifying data tracks.. Please be patient", 0FFh
ErrRSysTrk_Str	DB "Error in reading system track", 0FFh
ErrWSysTrk_Str	DB "Error in writing system track", 0FFh
TryAgain_Str	DB " ,try it again", 0FFh
ReadErr_Str	DB "Read error", 0FFh
BadHdNo_Str	DB "Incorrect head number", 0FFh
NoDrvOnline_Str	DB "No drives online.....", 0FFh
_292E	DB "Drive 1 online"
Drv0Online_Str	DB 0Ah, 0Dh, "Drive 0 online", 0Ah, 0Dh
		DB "Drive parameters set as follows:", 0FFh
Enter_Str	DB "Enter ", 0FFh

CurrCyl_Str	DB "Current cylinder ", 0FFh
CurrHd_Str	DB "Current head ", 0FFh
CurrSec_Str	DB "Current sector ", 0FFh
LastCyl_Str	DB "Last cylinder number -2 ", 0FFh
NumHeads_Str	DB "Number of heads -1 ", 0FFh
NumSct_Str	DB "Number of sectors -1 ", 0FFh
PrecompCyl_Str	DB "Precompensation cylinder -1 ", 0FFh
LunStat_Str	DB "Lun status byte ", 0FFh
FlagByte_Str	DB "Flag byte ", 0FFh
Interleave_Str	DB "Interleave Factor ", 0FFh

BurninTest_Str	DB 24 dup (20h)
		DB "10 Hour Burn-in test  Version 1.0", 0Ah, 0Dh, 0Ah, 0Dh, "     "
		DB "Burn-in test", 0Ah, 0Dh, 0Ah, 0Dh
		DB " 1)  Format Media", 0Ah, 0Dh
		DB " 2)  Format System Tracks (Track 0 Head 0 & 1)", 0Ah, 0Dh
		DB " 3)  Verify System Tracks (Rd/WR/Rd 1000 )", 0Ah, 0Dh
		DB " 4)  Zero System Tracks   (Write 000)", 0Ah, 0Dh
		DB " 5)  Read Data Tracks     (Even Tks in Odd out)", 0Ah, 0Dh
		DB " 6)  Write Data Tracks    (Even Tks in Odd out)", 0Ah, 0Dh
		DB " 7)  Random Reads         (50,000 Passes)", 0Ah, 0Dh
		DB " 8)  Random Writes        (50,000 Passes)", 0Ah, 0Dh
		DB " 9)  Random R/Ws          (50,000 Passes)", 0Ah, 0Dh
		DB " 10) Read Data Tracks     (Even Tks in Odd out) ", 0Ah, 0Dh
		DB " 11) Verify System Track  (1000 Passes)", 0Ah, 0Dh
		DB " 12) Ready For System test", 0Ah,0Dh, 0Ah, 0Dh, 0Ah, 0Dh, 0Ah, 0Dh
		DB "  Waiting for system to warm-up..", 0Dh, 0FFh
TestNum_Str	DB "    Presently Running Test #  ", 0FFh
TestDone_Str	DB " TEST COMPLETE , HEADS PARKED....", 0Ah, 0Dh, 0FFh
_2CE3		DB "Track    ", 0FFh
_2CED		DB 0Ah, 0Dh, "Pass ", 0FFh

CommandTable1	DB 041h, 043h, 044h, 046h	; A, C, D, F
		DB 048h, 04Eh, 052h, 056h	; H, N, R, V
		DB 057h, 058h, 012h		; W, X, ctrl-L
		DB 0FFh

CommandTable2	DB 042h, 049h, 042h, 043h	; BI, BC
		DB 046h, 021h, 04Dh, 053h	; F!, MS
		DB 050h, 053h, 052h, 052h	; PS, RR
		DB 052h, 05Ah, 050h, 04Bh	; RZ, PK
		DB 044h, 052h, 043h, 04Ch	; DR, CL
		DB 0FFh

CommandTable3	DB "RZ!", 0FFh

JumpTable	LJMP Cmd_A		; A: ???
		LJMP Cmd_C		; C: ???
		LJMP Cmd_DumpBlock	; D: Read and dump current sector (532 bytes)
		LJMP Cmd_Format		; F: format drive
		LJMP Cmd_H		; H:
		LJMP Cmd_NOP		; N: do nothing
		LJMP Cmd_Read		; R: read block into buffer
		LJMP Cmd_Verify		; V: verify drive
		LJMP Cmd_Write		; W: -
		LJMP Cmd_Xecute		; X: -
		LJMP Cmd_Restart	; ctrl-L: restart
		LJMP Cmd_Burnin		; BI: 10 hour burnin test
		LJMP Cmd_BC		; BC: -
		LJMP Cmd_FF		; F!: ???
		LJMP Cmd_MS		; MS: -
		LJMP Cmd_PS		; PS: -
		LJMP Cmd_RR		; RR: read random block (LBA 00.TH1.TL1)
		LJMP Cmd_Rezero		; RZ: rezero drive to track 0
		LJMP Cmd_ParkHeads	; PK: park heads
		LJMP Cmd_DR		; DR: dump 128 bytes data RAM
		LJMP Cmd_LimitFlag	; CL: display Limit flag status
		LJMP Cmd_Rezero1	; RZ!: rezero drive to track 1
Jump_OhOh	LJMP Cmd_OhOh		; ohoh


; **********************************************************************
;  PK command: park heads
; **********************************************************************
;
Cmd_ParkHeads	CLR C
		MOV A, #GeometryStart
		ADD A, #4h
		MOV R0, A
		MOV A, @R0		; copy NumberOf_Cyl
		MOV Target_CylH, A	; into Target_Cyl
		CLR C
		MOV A, #GeometryStart
		ADD A, #5h
		MOV R0, A
		MOV A, @R0
		MOV Target_CylL, A
		LCALL Do_Seek		; and perform a seek
		MOV DPTR, #HDParked_Str
		LCALL Ser_SendString
		LCALL Ser_SendCR
		RET


; **********************************************************************
;  RZ command: rezero drive to track 0
; **********************************************************************
;
Cmd_Rezero	CLR RecalTo_Trk1
		LCALL Do_Rezero
	 	RET

; **********************************************************************
;  A command: ???
; **********************************************************************
;
Cmd_A		MOV 3Ch, #0h
		LCALL A_Return		; simply return
		RET

; **********************************************************************
;  C command: ???
; **********************************************************************
;
Cmd_C		LCALL C_Return		; simply return
		LCALL _1D08
		RET


; **********************************************************************
;  D command: Read and dump current sector (532 bytes)
; **********************************************************************
;
Cmd_DumpBlock	MOV R2, #0h
		MOV R3, #0h
		LCALL Omti_DMAdrSet		; set DMA address to 0000h
		MOV R6, #14h
		MOV R7, #2h			; transfer 532 bytes
		MOV DPTR, #XRAMstart
		LCALL MFM_ReadSctr		; read current sector from disk
		MOV R6, #14h
		MOV R7, #2h
		MOV DPTR, #XRAMstart
		MOV R5, #16			; 16 bytes per line
Cmd_DumpBlock2	MOVX A, @DPTR			; get byte from RAM
		LCALL Ser_SendByte		;  and send through RS-232
		MOV A, #20h
		LCALL Ser_SendChar		;  followed by a space
		INC DPTR
		DJNZ R5, Cmd_DumpBlock1
		LCALL Ser_SendCR		; start new line after 16 bytes
		MOV R5, #16
Cmd_DumpBlock1	DJNZ R6, Cmd_DumpBlock2
		DJNZ R7, Cmd_DumpBlock3
		RET
Cmd_DumpBlock3	MOV R6, #0FFh
		SJMP Cmd_DumpBlock2


; **********************************************************************
;  DR command: Dump 128 bytes data RAM
; **********************************************************************
;
Cmd_DR		MOV R6, #10h
		MOV R7, #80h
		MOV R0, #0h
Cmd_DR2		MOV A, @R0
		INC R0
		LCALL Ser_SendByte
		MOV A, #20h
		LCALL Ser_SendChar
		DJNZ R6, Cmd_DR1
		LCALL Ser_SendCR
		MOV R6, #10h
Cmd_DR1		DJNZ R7, Cmd_DR2
		RET


; **********************************************************************
;  CL command: display Limit flag status
; **********************************************************************
;
Cmd_LimitFlag	JBC LimitFlag, Cmd_LimitFlag1
		SETB LimitFlag
		MOV DPTR, #Lim16M_Str		; (2743h)
Cmd_LimitFlag2	LCALL Ser_SendString
		LCALL Ser_SendCR
		RET
Cmd_LimitFlag1	MOV DPTR, #LimReset_Str		; (2761h)
		SJMP Cmd_LimitFlag2


; **********************************************************************
;  F command: format drive
; **********************************************************************
;
Cmd_Format	LCALL Do_Format
		RET

; **********************************************************************
;  H command: ???
; **********************************************************************
;
Cmd_H:	MOV	R0, 3Ch			;2DF8  A8 3C
	MOV	P2, #40h		;2DFA  75 A0 40
_2DFD:	MOVX	A, @R0			;2DFD  E2
	MOV	B, A			;2DFE  F5 F0
	CJNE	A, #0Dh, _2E04		;2E00  B4 0D 01
	RET				;2E03  22
_2E04:	CJNE	A, #20h, _2E0A		;2E04  B4 20 03
	INC	R0			;2E07  08
	SJMP	_2DFD			;2E08  80 F3
_2E0A:	INC	R0			;2E0A  08
	MOV	3Ch, R0			;2E0B  88 3C
	CLR	C			;2E0D  C3
	SUBB	A, #30h			;2E0E  94 30
	PUSH	Acc			;2E10  C0 E0
		MOV A, #6h
		LCALL Get_PositionVar		; get NumberOf_Hd
	MOV	B, A			;2E17  F5 F0
	POP	Acc			;2E19  D0 E0
	CJNE	A, B, _2E22		;2E1B  B5 F0 04
_2E1E		LCALL Select_MFMhd1
		RET
_2E22:	JNC	_2E26			;2E22  50 02
	SJMP	_2E1E			;2E24  80 F8
_2E26:		MOV DPTR, #BadHdNo_Str
		LCALL Ser_SendString
		LCALL Ser_SendCR
		RET

; **********************************************************************
;  N command: do nothing
; **********************************************************************
;
Cmd_NOP		RET


; **********************************************************************
;  R command: read block into buffer
; **********************************************************************
;
Cmd_Read	LCALL NotYet_1
		SETB 6Fh
		LCALL _0EED
		JB F0, Cmd_Read1
		RET
Cmd_Read1	MOV DPTR, #ReadErr_Str	; (28F7h)
		LCALL Ser_SendString
		LCALL Ser_SendCR
		RET


; **********************************************************************
;  V command: verify drive
; **********************************************************************
;
Cmd_Verify	SETB 2Ch
		LJMP HD_Installer62


; **********************************************************************
;  W command: write buffer into block (not yet)
; **********************************************************************
;
Cmd_Write	RET


; **********************************************************************
;  X command: execute whatever (not yet)
; **********************************************************************
;
Cmd_Xecute	RET


; **********************************************************************
;  ctrl-L command: restart program
; **********************************************************************
;
Cmd_Restart	MOV DPTR, #Restarting_Str
		LCALL Ser_SendString
		LCALL Ser_SendCR
		LJMP MainStart


; **********************************************************************
;  BI command: 10 hour burn-in test
; **********************************************************************
;
Cmd_Burnin	MOV R7, #30
Cmd_Burnin1	LCALL Ser_SendCR		; send 30 empty lines
		DJNZ R7, Cmd_Burnin1
		MOV DPTR, #BurninTest_Str	; (2A35h)
		LCALL Ser_SendString
		MOV R2, #50h
		MOV R3, #50h
		LCALL Delay
; do test #01 -- formatting
		MOV DPTR, #TestNum_Str		; (2CA0h)
		LCALL Ser_SendString
		MOV A, #'1'
		LCALL Ser_SendChar
		MOV A, #0Dh
		LCALL Ser_SendChar
		MOV 5Bh, #0h
		LCALL Do_Format
		MOV 5Bh, #80h
		LCALL Do_Rezero
		MOV LBA_Hi, #0h
		MOV LBA_Mi, #0h
		MOV LBA_Lo, #0h
; do test #02 -- Format System Tracks
		MOV DPTR, #TestNum_Str
		LCALL Ser_SendString
		MOV A, #'2'
		LCALL Ser_SendChar
		MOV A, #0Dh
		LCALL Ser_SendChar
		LCALL _03D2
		LCALL _12B6
		LCALL _03D2
		SETB 6Fh
; do test #03 -- Verify System Tracks (Rd/Wr/Rd 1000x)
		MOV DPTR, #TestNum_Str
		LCALL Ser_SendString
		MOV A, #'3'
		LCALL Ser_SendChar
		MOV A, #0Dh
		LCALL Ser_SendChar
; read
		MOV tmp_Cyl1, #1000 / 256
		MOV tmp_Hd, #1000 # 256
Cmd_Burnin3	MOV 56h, #8h
		MOV LBA_Hi, #0h
		MOV LBA_Mi, #0h
		MOV LBA_Lo, #0h
		MOV A, #7h
		LCALL Get_PositionVar		; get NumberOf_Sec
		MOV 5Ah, A
		MOV 5Bh, #0h
Cmd_Burnin4	LCALL _03E7
		JB F0, Hang			; crash on error
		LCALL Cmd_BI_Next
		JB F0, Cmd_Burnin2		; done, next step
		MOV A, #7h
		LCALL Get_PositionVar		; get NumberOf_Sec
		CJNE A, LBA_Lo, Cmd_Burnin3
		SJMP Cmd_Burnin4
; write
Cmd_Burnin2	MOV tmp_Cyl1, #1000 / 256
		MOV tmp_Hd, #1000 # 256
Cmd_Burnin6	MOV LBA_Lo, #0h
Cmd_Burnin7	LCALL Cmd_BI_Ret		; do nothing
		MOV 56h, #0Ah
		LCALL _03F8
		JB F0, Hang			; crash on error
		LCALL Cmd_BI_Next
		JB F0, Cmd_Burnin5
		MOV A, #7h
		LCALL Get_PositionVar		; get NumberOf_Sec
		CJNE A, LBA_Lo, Cmd_Burnin6
		SJMP Cmd_Burnin7
; read
Cmd_Burnin5	MOV tmp_Cyl1, #1000 / 256
		MOV tmp_Hd, #1000 # 256
Cmd_Burnin9	MOV LBA_Lo, #0h
Cmd_Burnin10	MOV 56h, #8h
		LCALL _03E7
		JB F0, Hang			; crash on error
		LCALL Cmd_BI_Next
		JB F0, Cmd_Burnin8
		MOV A, #7h
		LCALL Get_PositionVar		; get NumberOf_Sec
		CJNE A, LBA_Lo, Cmd_Burnin9
		SJMP Cmd_Burnin10
; end up here if error occured
Hang		LJMP Hang
; do test #04 -- Zero System Tracks   (Write 000)
Cmd_Burnin8	MOV DPTR, #TestNum_Str
		LCALL Ser_SendString
		MOV A, #'4'
		LCALL Ser_SendChar
		MOV A, #0Dh
		LCALL Ser_SendChar
		LCALL Cmd_BI_Ret		; do nothing
		MOV 56h, #0Ah
		MOV LBA_Lo, #0h
		LCALL _03F8
		JB F0, Hang			; crash on error
		LCALL _03F8
		JB F0, Hang			; crash on error
; do test #05 -- Read Data Tracks (Even Tracks in, Odd out)
		MOV DPTR, #TestNum_Str
		LCALL Ser_SendString
		MOV A, #'5'
		LCALL Ser_SendChar
		MOV A, #0Dh
		LCALL Ser_SendChar
		MOV 5Bh, #0h
		LCALL Do_Rezero
		MOV LBA_Lo, #0h
Cmd_Burnin11	LCALL _03E7
		NOP
		NOP
		NOP
; jump in here to continue Burn-in test #10
Cmd_Burnin20	MOV A, #2h
		LCALL Get_PositionVar		; get Current_Hd
		MOV B, A
		MOV A, #6h
		LCALL Get_PositionVar		; NumberOf_Hd
		CJNE A, B, Cmd_Burnin11
		MOV A, #6h
		LCALL Get_PositionVar		; NumberOf_Hd
		MOV tmp_Cyl1, A
Cmd_Burnin13	LCALL _12B6
		JB F0, Cmd_Burnin12
		MOV A, tmp_Cyl1
		DEC A
		MOV tmp_Cyl1, A
		JNZ Cmd_Burnin13
		LJMP Cmd_Burnin11
; do test #06 -- Write Data Tracks (Even Tracks in, Odd out)
; actually there is not really a write operation - work in progress?
Cmd_Burnin12	MOV DPTR, #TestNum_Str
		LCALL Ser_SendString
		MOV A, #'6'
		LCALL Ser_SendChar
		MOV A, #0Dh
		LCALL Ser_SendChar
		MOV 56h, #0Ah
		LCALL Cmd_BI_Ret		; do nothing
; do test #07 -- Random Reads (50,000 Passes)
		MOV DPTR, #TestNum_Str
		LCALL Ser_SendString
		MOV A, #'7'
		LCALL Ser_SendChar
		MOV A, #0Dh
		LCALL Ser_SendChar
		MOV tmp_Cyl1, #50000 / 256
		MOV tmp_Hd, #50000 # 256
Cmd_Burnin15	LCALL Cmd_RR			; perform random read
		LCALL Cmd_BI_Next
		JB F0, Cmd_Burnin14
		SJMP Cmd_Burnin15
; do test #08 -- Random Writes (50,000 Passes)
; here they forgot to write -- do nothing!
Cmd_Burnin14	MOV DPTR, #TestNum_Str
		LCALL Ser_SendString
		MOV A, #'8'
		LCALL Ser_SendChar
		MOV A, #0Dh
		LCALL Ser_SendChar
		MOV tmp_Cyl1, #50000 / 256
		MOV tmp_Hd, #50000 # 256
Cmd_Burnin17	LCALL Cmd_BI_Next
		JB F0, Cmd_Burnin16
		SJMP Cmd_Burnin17
; do test #09 -- Random R/Ws (50,000 Passes)
; actually random nothing
Cmd_Burnin16	MOV DPTR, #TestNum_Str
		LCALL Ser_SendString
		MOV A, #'9'
		LCALL Ser_SendChar
		MOV A, #0Dh
		LCALL Ser_SendChar
		MOV tmp_Cyl1, #50000 / 256
		MOV tmp_Hd, #50000 # 256
Cmd_Burnin19	LCALL Cmd_BI_Next
		JB F0, Cmd_Burnin18
		SJMP Cmd_Burnin19
; do test #10 -- Read Data Tracks (Even Tracks in, Odd out)
Cmd_Burnin18	MOV DPTR, #TestNum_Str
		LCALL Ser_SendString
		MOV A, #'1'
		LCALL Ser_SendChar
		MOV A, #'0'
		LCALL Ser_SendChar
		MOV A, #0Dh
		LCALL Ser_SendChar
		LJMP Cmd_Burnin20
;
; test completed. But how do we get there ?????
_302F		MOV DPTR, #TestDone_Str		; (2CBF) *** dead code ****
		LCALL Ser_SendString
		MOV A, #4h
		LCALL Get_PositionVar		; get NumberOf_CylH
		MOV LBA_Mi, A			; into LBA_Mi
		MOV A, #5h
		LCALL Get_PositionVar		; get NumberOf_CylL
		MOV LBA_Lo, A			; into LBA_Lo
		LCALL _0EED			; read one last block...
		SJMP $				; ...and die

_3048		RET				; *** dead code ***
;
Cmd_BI_Ret	RET
;
; decrement loop counter 'tmp_Cyl1.tmp_Hd' and exit with F0 set when at zero
Cmd_BI_Next	CLR F0
		MOV R4, tmp_Cyl1
		MOV R5, tmp_Hd
		MOV A, R5
		JZ Cmd_BI_Next1
		DJNZ R5, Cmd_BI_Next2
Cmd_BI_Next1	MOV A, R4
		JZ Cmd_BI_Next3
		MOV tmp_Hd, #0FFh
		DJNZ R4, Cmd_BI_Next2
Cmd_BI_Next3	SETB F0
Cmd_BI_Next2	MOV tmp_Cyl1, R4
		MOV tmp_Hd, R5
		RET


; **********************************************************************
;  BC command: not yet
; **********************************************************************
;
Cmd_BC	RET


; **********************************************************************
;  F! command:
; **********************************************************************
;
Cmd_FF		SETB RecalTo_Trk1
		MOV R7, #4
		MOV R1, #LBA_Hi
Cmd_FF1		MOV @R1, #0h		; zero LBA bytes
		INC R1
		DJNZ R7, Cmd_FF1
		LCALL _03D2
		RET


; **********************************************************************
;  MS command: not yet
; **********************************************************************
;
Cmd_MS		RET


; **********************************************************************
;  PS command: not yet
; **********************************************************************
;
Cmd_PS		RET


; **********************************************************************
;  RR command: read random block
; **********************************************************************
;
Cmd_RR		SETB 6Fh
		MOV 56h, #8h
		MOV LBA_Hi, #0h
		MOV A, TH1
		ANL A, #9Fh
		MOV LBA_Mi, A			; use timer count as LBA
		MOV A, TL1
		MOV LBA_Lo, A
		MOV 5Ah, #1h
		MOV 5Bh, #0h
		LCALL _0EED
		JB F0, Cmd_RR1
		RET
Cmd_RR1		MOV A, #'N'			; print 'N' when error occured
		LCALL Ser_SendChar
		RET


; **********************************************************************
;  RZ! command: rezero drive to track 1
; **********************************************************************
;
Cmd_Rezero1	SETB RecalTo_Trk1
		LCALL Do_Rezero
		RET

	END
